// JavaScript Document
// 画像フィルター加工ツール - 各種エフェクト
// みんなの知識ちょっと便利帳
// 2025-05-02
// https://www.benricho.org/Tips/image-transform/

function Original(imgId,iplImage){var newIplImage=cvCloneImage(iplImage);cvShowImage(imgId,newIplImage)}function Soft_Amaro(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);var bg=cvCloneImage(iplImage);cvSmooth(bg,bg,CV_SMOOTH_TYPE.GAUSSIAN,7);cvBlendImage(bg,newIplImage,newIplImage,CV_BLEND_MODE.SCREEN);var AMARO_RED_TONE_CURVE_UNDER_X=0;var AMARO_RED_TONE_CURVE_UNDER_Y=20;var AMARO_RED_TONE_CURVE_OVER_X=255;var AMARO_RED_TONE_CURVE_OVER_Y=255;var AMARO_GREEN_TONE_CURVE_UNDER_X=10;var AMARO_GREEN_TONE_CURVE_UNDER_Y=0;var AMARO_GREEN_TONE_CURVE_OVER_X=255;var AMARO_GREEN_TONE_CURVE_OVER_Y=255;var AMARO_BLUE_TONE_CURVE_UNDER_X=0;var AMARO_BLUE_TONE_CURVE_UNDER_Y=20;var AMARO_BLUE_TONE_CURVE_OVER_X=255;var AMARO_BLUE_TONE_CURVE_OVER_Y=255;cvToneCurve(newIplImage,newIplImage,AMARO_RED_TONE_CURVE_UNDER_X,AMARO_RED_TONE_CURVE_UNDER_Y,AMARO_RED_TONE_CURVE_OVER_X,AMARO_RED_TONE_CURVE_OVER_Y,0);cvToneCurve(newIplImage,newIplImage,AMARO_GREEN_TONE_CURVE_UNDER_X,AMARO_GREEN_TONE_CURVE_UNDER_Y,AMARO_GREEN_TONE_CURVE_OVER_X,AMARO_GREEN_TONE_CURVE_OVER_Y,1);cvToneCurve(newIplImage,newIplImage,AMARO_BLUE_TONE_CURVE_UNDER_X,AMARO_BLUE_TONE_CURVE_UNDER_Y,AMARO_BLUE_TONE_CURVE_OVER_X,AMARO_BLUE_TONE_CURVE_OVER_Y,2);cvShowImage(imgId,newIplImage)}catch(ex){alert("EqualizeHist : "+ex)}} function EqualizeHist(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);cvCvtColor(iplImage,newIplImage,CV_CODE.RGB2HSV);cvEqualizeHist(newIplImage,newIplImage,2);cvCvtColor(newIplImage,newIplImage,CV_CODE.HSV2RGB);cvShowImage(imgId,newIplImage)}catch(ex){alert("EqualizeHist : "+ex)}} function Comic(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);cvCvtColor(iplImage,newIplImage,CV_CODE.RGB2GRAY);var cannyImage=cvCreateImage(newIplImage.width,newIplImage.height);cvCanny(newIplImage,cannyImage,20,100);var UNDER=20;var OVER=200;for(var i=0;i<newIplImage.height;i++){for(var j=0;j<newIplImage.width;j++){var ji=(j+i*newIplImage.width)*CHANNELS;if(newIplImage.RGBA[ji]<UNDER){newIplImage.RGBA[ji]=0;newIplImage.RGBA[1+ji]=0;newIplImage.RGBA[2+ji]=0}else if(newIplImage.RGBA[ji]>OVER){newIplImage.RGBA[ji]=255;newIplImage.RGBA[1+ji]=255;newIplImage.RGBA[2+ji]=255}else{newIplImage.RGBA[ji]=cannyImage.RGBA[ji];newIplImage.RGBA[1+ji]=cannyImage.RGBA[ji];newIplImage.RGBA[2+ji]=cannyImage.RGBA[ji]}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Comic : "+ex)}} function HDR_Xpro(imgId,iplImage){try{var gray=cvCloneImage(iplImage);cvCvtColor(gray,gray,CV_CODE.RGB2GRAY);var miniGray=cvCreateImage(gray.width/2,gray.height/2);cvResize(gray,miniGray,CV_INTER.CUBIC);for(var i=0;i<miniGray.height;i++){for(var j=0;j<miniGray.width;j++){var v=255-miniGray.RGBA[(j+i*miniGray.width)*CHANNELS];miniGray.RGBA[(j+i*miniGray.width)*CHANNELS]=v;miniGray.RGBA[1+(j+i*miniGray.width)*CHANNELS]=v;miniGray.RGBA[2+(j+i*miniGray.width)*CHANNELS]=v}} for(var i=0;i<3;i++) cvSmooth(miniGray,miniGray,CV_SMOOTH_TYPE.GAUSSIAN,7);cvResize(miniGray,gray,CV_INTER.CUBIC);var newIplImage=cvCloneImage(iplImage);var blendMode=CV_BLEND_MODE.OVER_LAY;for(var i=0;i<3;i++) cvBlendImage(newIplImage,gray,newIplImage,blendMode);var X_PRO_GREEN_TONE_CURVE_UNDER_X=50;var X_PRO_GREEN_TONE_CURVE_UNDER_Y=0;var X_PRO_GREEN_TONE_CURVE_OVER_X=200;var X_PRO_GREEN_TONE_CURVE_OVER_Y=255;var X_PRO_RED_TONE_CURVE_UNDER_X=50;var X_PRO_RED_TONE_CURVE_UNDER_Y=0;var X_PRO_RED_TONE_CURVE_OVER_X=200;var X_PRO_RED_TONE_CURVE_OVER_Y=255;cvToneCurve(newIplImage,newIplImage,X_PRO_RED_TONE_CURVE_UNDER_X,X_PRO_RED_TONE_CURVE_UNDER_Y,X_PRO_RED_TONE_CURVE_OVER_X,X_PRO_RED_TONE_CURVE_OVER_Y,0);cvToneCurve(newIplImage,newIplImage,X_PRO_GREEN_TONE_CURVE_UNDER_X,X_PRO_GREEN_TONE_CURVE_UNDER_Y,X_PRO_GREEN_TONE_CURVE_OVER_X,X_PRO_GREEN_TONE_CURVE_OVER_Y,1);cvShowImage(imgId,newIplImage)}catch(ex){alert("HDR_Xpro : "+ex)}} function Reflection01(r,o){try{for(var a=o.width,t=o.height,e=cvCreateImage(a,2*t),f=0;f<t;f++)for(var A=0;A<a;A++)for(var N=(A+f*a)*CHANNELS,c=(A+f*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];for(f=0;f<t;f++)for(A=0;A<a;A++)for(N=(A+(t-f-1)*a)*CHANNELS,c=(A+(f+t)*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];cvShowImage(r,e)}catch(r){alert("Reflection01 : "+r)}}function Reflection02(r,o){try{for(var a=o.width,t=o.height,e=cvCreateImage(a,2*t),f=0;f<t;f++)for(var A=0;A<a;A++)for(var N=(A+f*a)*CHANNELS,c=(A+f*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];for(f=0;f<t;f++)for(var v=1-f/t,A=0;A<a;A++){for(N=(A+(t-f-1)*a)*CHANNELS,c=(A+(f+t)*a)*CHANNELS,R=0;R<3;R++)e.RGBA[c+R]=o.RGBA[N+R]*v+255*(1-v);e.RGBA[c+3]=255}cvShowImage(r,e)}catch(r){alert("Reflection02 : "+r)}}function Reflection03(r,o){try{for(var a=o.width,t=o.height,e=cvCreateImage(a,2*t),f=0;f<t;f++)for(var A=0;A<a;A++)for(var N=(A+f*a)*CHANNELS,c=(A+f*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];for(f=0;f<t;f++)for(var v=1-f/t,h=.1*Math.sin(f/5)+.9,A=0;A<a;A++){for(N=(A+(t-f-1)*a)*CHANNELS,c=(A+(f+t)*a)*CHANNELS,R=0;R<3;R++){var i=o.RGBA[N+R];e.RGBA[c+R]=i*v*h+255*(1-v)}e.RGBA[c+3]=255}cvShowImage(r,e)}catch(r){alert("Reflection03 : "+r)}}function Reflection04(r,o){try{for(var a=o.width,t=o.height,e=cvCreateImage(a,2*t),f=0;f<t;f++)for(var A=0;A<a;A++)for(var N=(A+f*a)*CHANNELS,c=(A+f*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];for(f=0;f<t;f++)for(var v=1-f/t,A=0;A<a;A++){var h=t-f-1+Math.floor(3*Math.sin(A/10));if(!(h<0||t<=h)){for(N=(A+h*a)*CHANNELS,c=(A+(f+t)*a)*CHANNELS,R=0;R<3;R++)e.RGBA[c+R]=o.RGBA[N+R]*v+255*(1-v);e.RGBA[c+3]=255}}cvShowImage(r,e)}catch(r){alert("Reflection04 : "+r)}}function Reflection05(r,o){try{for(var a=o.width,t=o.height,e=cvCreateImage(a,2*t),f=0;f<t;f++)for(var A=0;A<a;A++)for(var N=(A+f*a)*CHANNELS,c=(A+f*a)*CHANNELS,R=0;R<4;R++)e.RGBA[c+R]=o.RGBA[N+R];for(f=0;f<t;f++)for(var v=1-f/t,A=0;A<a;A++){var h=A+Math.floor(3*Math.sin(f/5+2*Math.random()));if(!(h<0||a<=h)){for(N=(h+(t-f-1)*a)*CHANNELS,c=(A+(f+t)*a)*CHANNELS,R=0;R<3;R++)e.RGBA[c+R]=o.RGBA[N+R]*v+255*(1-v);e.RGBA[c+3]=255}}cvShowImage(r,e)}catch(r){alert("Reflection05 : "+r)}} function Reflection06(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height*1.3);var s=newIplImage.height-iplImage.height;var ys=0.5;var a=-ys/s;for(var i=0;i<newIplImage.height;i++){for(var j=0;j<newIplImage.width;j++){for(var c=0;c<3;c++){if(i<iplImage.height){newIplImage.RGBA[c+(j+i*newIplImage.width)*CHANNELS]=iplImage.RGBA[c+(j+i*newIplImage.width)*CHANNELS]}else{var y=(i-iplImage.height);var nv=(a*y+ys)*iplImage.RGBA[c+(j+(iplImage.height-1-y)*newIplImage.width)*CHANNELS];newIplImage.RGBA[c+(j+i*newIplImage.width)*CHANNELS]=nv}}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Test : "+ex)}} function HDR(imgId,iplImage){var gray=cvCloneImage(iplImage);cvCvtColor(gray,gray,CV_CODE.RGB2GRAY);var miniGray=cvCreateImage(gray.width/2,gray.height/2);cvResize(gray,miniGray,CV_INTER.CUBIC);for(var i=0;i<miniGray.height;i++){for(var j=0;j<miniGray.width;j++){var v=255-miniGray.RGBA[(j+i*miniGray.width)*CHANNELS];miniGray.RGBA[(j+i*miniGray.width)*CHANNELS]=v;miniGray.RGBA[1+(j+i*miniGray.width)*CHANNELS]=v;miniGray.RGBA[2+(j+i*miniGray.width)*CHANNELS]=v}} for(var i=0;i<3;i++) cvSmooth(miniGray,miniGray,CV_SMOOTH_TYPE.GAUSSIAN,7);cvResize(miniGray,gray,CV_INTER.CUBIC);var newIplImage=cvCloneImage(iplImage);var blendMode=CV_BLEND_MODE.OVER_LAY;for(var i=0;i<3;i++) cvBlendImage(newIplImage,gray,newIplImage,blendMode);cvShowImage(imgId,newIplImage)} function Labeling(imgId,iplImage){try{var iplImage1=cvCloneImage(iplImage);cvCvtColor(iplImage1,iplImage1,CV_CODE.RGB2GRAY);cvThreshold(iplImage1,iplImage1,100,255,CV_THRESHOLD_TYPE.THRESH_BINARY_INV);var iplImage2=cvLabeling(iplImage1);min_val=new Array(4);max_val=new Array(4);min_locs=new Array(4);max_locs=new Array(4);for(var i=0;i<4;i++){min_locs[i]=new CvPoint();max_locs[i]=new CvPoint()} cvMinMaxLoc(iplImage2,min_val,max_val,min_locs,max_locs);var maxV=max_val[0];for(i=0;i<iplImage2.height;i++){for(j=0;j<iplImage2.width;j++){var v=iplImage2.RGBA[(j+i*iplImage1.width)*CHANNELS];iplImage1.RGBA[(j+i*iplImage2.width)*CHANNELS]=255*v/maxV;iplImage1.RGBA[1+(j+i*iplImage2.width)*CHANNELS]=255;iplImage1.RGBA[2+(j+i*iplImage2.width)*CHANNELS]=(v==0)?0:255;iplImage1.RGBA[3+(j+i*iplImage2.width)*CHANNELS]=255}} cvCvtColor(iplImage1,iplImage1,CV_CODE.HSV2RGB);cvShowImage(imgId,iplImage1)}catch(ex){alert("Labeling : "+ex)}} function Xpro(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);var X_PRO_GREEN_TONE_CURVE_UNDER_X=50;var X_PRO_GREEN_TONE_CURVE_UNDER_Y=0;var X_PRO_GREEN_TONE_CURVE_OVER_X=200;var X_PRO_GREEN_TONE_CURVE_OVER_Y=255;var X_PRO_RED_TONE_CURVE_UNDER_X=50;var X_PRO_RED_TONE_CURVE_UNDER_Y=0;var X_PRO_RED_TONE_CURVE_OVER_X=200;var X_PRO_RED_TONE_CURVE_OVER_Y=255;cvToneCurve(newIplImage,newIplImage,X_PRO_RED_TONE_CURVE_UNDER_X,X_PRO_RED_TONE_CURVE_UNDER_Y,X_PRO_RED_TONE_CURVE_OVER_X,X_PRO_RED_TONE_CURVE_OVER_Y,0);cvToneCurve(newIplImage,newIplImage,X_PRO_GREEN_TONE_CURVE_UNDER_X,X_PRO_GREEN_TONE_CURVE_UNDER_Y,X_PRO_GREEN_TONE_CURVE_OVER_X,X_PRO_GREEN_TONE_CURVE_OVER_Y,1);cvShowImage(imgId,newIplImage)}catch(ex){alert("xpro : "+ex)}} function Rainbow(imgId,iplImage){try{var layer1=cvCreateImage(iplImage.width,iplImage.height);var max=layer1.width*layer1.width+layer1.height*layer1.height;for(i=0;i<layer1.height;i++){for(j=0;j<layer1.width;j++){var v=j*j+i*i;layer1.RGBA[(j+i*layer1.width)*CHANNELS]=255*v/max;layer1.RGBA[1+(j+i*layer1.width)*CHANNELS]=255;layer1.RGBA[2+(j+i*layer1.width)*CHANNELS]=255;layer1.RGBA[3+(j+i*layer1.width)*CHANNELS]=255}} cvCvtColor(layer1,layer1,CV_CODE.HSV2RGB);var newIplImage=cvCloneImage(iplImage);var bg=cvCloneImage(iplImage);cvSmooth(bg,bg,CV_SMOOTH_TYPE.GAUSSIAN,7);cvBlendImage(bg,newIplImage,newIplImage,CV_BLEND_MODE.SCREEN);cvBlendImage(newIplImage,layer1,newIplImage,CV_BLEND_MODE.SOFT_LIGHT);cvShowImage(imgId,newIplImage)}catch(ex){alert("Rainbow : "+ex)}}function Rainbow02(t,a){try{for(var h=cvCreateImage(a.width,a.height),e=a.width/3.5,r=a.height/3.8,v=Math.sqrt(e*e+r*r),i=0;i<h.height;i++)for(var o=0;o<h.width;o++){var C=o-e,c=i-r,C=Math.sqrt(C*C+c*c)/v*90,c=(o+i*h.width)*CHANNELS;h.RGBA[c]=C,h.RGBA[1+c]=255,h.RGBA[2+c]=255,h.RGBA[3+c]=255}cvCvtColor(h,h,CV_CODE.HSV2RGB);var R=cvCloneImage(a);cvBlendImage(R,h,R,CV_BLEND_MODE.SCREEN),cvShowImage(t,R)}catch(t){alert("Rainbow02 : "+t)}}function Rainbow03(t,a){try{for(var h=cvCreateImage(a.width,a.height),e=0;e<h.height;e++)for(var r=0;r<h.width;r++){var v=r/a.width*180,i=(r+e*h.width)*CHANNELS;h.RGBA[i]=v,h.RGBA[1+i]=180,h.RGBA[2+i]=240,h.RGBA[3+i]=108}cvCvtColor(h,h,CV_CODE.HSV2RGB);var o=cvCloneImage(a);cvBlendImage(o,h,o,CV_BLEND_MODE.HARD_LIGHT),cvShowImage(t,o)}catch(t){alert("Rainbow03 : "+t)}}function Gradetion(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);var filter=cvCreateImage(iplImage.width,iplImage.height);for(i=0;i<filter.height;i++){for(j=0;j<filter.width;j++){filter.RGBA[(j+i*filter.width)*CHANNELS]=j*210/filter.width+45;filter.RGBA[1+(j+i*filter.width)*CHANNELS]=j*110/filter.width+10;filter.RGBA[2+(j+i*filter.width)*CHANNELS]=90-j*90/filter.width;filter.RGBA[3+(j+i*filter.width)*CHANNELS]=255}} cvBlendImage(newIplImage,filter,newIplImage,CV_BLEND_MODE.SCREEN);cvShowImage(imgId,newIplImage)}catch(ex){alert("Gradetion : "+ex)}} function SoftFocus(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);var bg=cvCloneImage(iplImage);cvSmooth(bg,bg,CV_SMOOTH_TYPE.GAUSSIAN,7);cvBlendImage(bg,newIplImage,newIplImage,CV_BLEND_MODE.SCREEN);cvShowImage(imgId,newIplImage)}catch(ex){alert("SoftFocus : "+ex)}}function red_blue(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);cvCvtColor(newIplImage,newIplImage,CV_CODE.RGB2GRAY);var pt1=new CvPoint();pt1.x=Math.floor(newIplImage.width*Math.random());pt1.y=Math.floor(newIplImage.height*Math.random());var pt2=new CvPoint();pt2.x=Math.floor(newIplImage.width*Math.random());pt2.y=Math.floor(newIplImage.height*Math.random());if(pt1.x==pt2.x){}else{var katamuki=(pt1.y-pt2.y)/(pt1.x-pt2.x);for(i=0;i<newIplImage.height;i++){for(j=0;j<newIplImage.width;j++){if(i>katamuki*(j-pt1.x)+pt1.y){newIplImage.RGBA[1+(j+i*newIplImage.width)*CHANNELS]=0;newIplImage.RGBA[2+(j+i*newIplImage.width)*CHANNELS]=0}else{newIplImage.RGBA[(j+i*newIplImage.width)*CHANNELS]=0;newIplImage.RGBA[1+(j+i*newIplImage.width)*CHANNELS]=0}}}} var color=new CvScalar();color.r=color.g=color.b=255;cvLine(newIplImage,pt1,pt2,color,11,!1);cvShowImage(imgId,newIplImage)}catch(ex){alert("red_blue : "+ex)}}function green_yellow(a,t){try{var r=cvCloneImage(t);cvCvtColor(r,r,CV_CODE.RGB2GRAY);var h=new CvPoint;h.x=Math.floor(r.width*Math.random()),h.y=Math.floor(r.height*Math.random());var o=new CvPoint;if(o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random()),h.x!=o.x){var n=(h.y-o.y)/(h.x-o.x);for(i=0;i<r.height;i++)for(j=0;j<r.width;j++)i>n*(j-h.x)+h.y&&(r.RGBA[(j+i*r.width)*CHANNELS]=0),r.RGBA[2+(j+i*r.width)*CHANNELS]=0}var e=new CvScalar;e.r=e.g=e.b=255,cvLine(r,h,o,e,11,!1),cvShowImage(a,r)}catch(a){alert("green_yellow : "+a)}}function pink_white(a,t){try{var r=cvCloneImage(t),h=.5,o=new CvPoint;o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random());var n=new CvPoint;if(n.x=Math.floor(r.width*Math.random()),n.y=Math.floor(r.height*Math.random()),o.x!=n.x)for(var i=(o.y-n.y)/(o.x-n.x),e=0;e<r.height;e++)for(var v=0;v<r.width;v++){var w,d,l=(v+e*r.width)*CHANNELS,f=r.RGBA[0+l],M=r.RGBA[1+l],g=r.RGBA[2+l],c=e>i*(v-o.x)+o.y?(w=255,d=182,193):d=w=255;r.RGBA[0+l]=.5*f+h*w,r.RGBA[1+l]=.5*M+h*d,r.RGBA[2+l]=.5*g+h*c}var x=new CvScalar;x.r=x.g=x.b=255,cvLine(r,o,n,x,11,!1),cvShowImage(a,r)}catch(a){alert("pink_white : "+a)}}function orange_purple(a,t){try{var r=cvCloneImage(t),h=.5,o=new CvPoint;o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random());var n=new CvPoint;if(n.x=Math.floor(r.width*Math.random()),n.y=Math.floor(r.height*Math.random()),o.x!=n.x)for(var i=(o.y-n.y)/(o.x-n.x),e=0;e<r.height;e++)for(var v=0;v<r.width;v++){var w,d,l=(v+e*r.width)*CHANNELS,f=r.RGBA[0+l],M=r.RGBA[1+l],g=r.RGBA[2+l],c=e>i*(v-o.x)+o.y?(w=255,d=165,0):(d=0,w=128);r.RGBA[0+l]=.5*f+h*w,r.RGBA[1+l]=.5*M+h*d,r.RGBA[2+l]=.5*g+h*c}var x=new CvScalar;x.r=x.g=x.b=255,cvLine(r,o,n,x,11,!1),cvShowImage(a,r)}catch(a){alert("orange_purple : "+a)}}function sakura_mint(a,t){try{var r=cvCloneImage(t),h=.5,o=new CvPoint;o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random());var n=new CvPoint;if(n.x=Math.floor(r.width*Math.random()),n.y=Math.floor(r.height*Math.random()),o.x!=n.x)for(var i=(o.y-n.y)/(o.x-n.x),e=0;e<r.height;e++)for(var v=0;v<r.width;v++){var w,d,l=(v+e*r.width)*CHANNELS,f=r.RGBA[0+l],M=r.RGBA[1+l],g=r.RGBA[2+l],c=e>i*(v-o.x)+o.y?(w=255,d=200,220):(d=255,w=152);r.RGBA[0+l]=.5*f+h*w,r.RGBA[1+l]=.5*M+h*d,r.RGBA[2+l]=.5*g+h*c}var x=new CvScalar;x.r=x.g=x.b=255,cvLine(r,o,n,x,11,!1),cvShowImage(a,r)}catch(a){alert("sakura_mint : "+a)}}function autumn_gold(a,t){try{var r=cvCloneImage(t),h=new CvPoint;h.x=Math.floor(r.width*Math.random()),h.y=Math.floor(r.height*Math.random());var o=new CvPoint;if(o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random()),h.x!=o.x)for(var n=(h.y-o.y)/(h.x-o.x),i=0;i<r.height;i++)for(var e=0;e<r.width;e++){var v,w,d=(e+i*r.width)*CHANNELS,l=r.RGBA[0+d],f=r.RGBA[1+d],M=r.RGBA[2+d],g=i>n*(e-h.x)+h.y?(v=255,w=235,0):(v=200,w=20,60);r.RGBA[0+d]=.5*l+.5*v,r.RGBA[1+d]=.5*f+.5*w,r.RGBA[2+d]=.5*M+.5*g}var c=new CvScalar;c.r=c.g=c.b=255,cvLine(r,h,o,c,11,!1),cvShowImage(a,r)}catch(a){alert("autumn_gold : "+a)}}function fantasy_night(a,t){try{var r=cvCloneImage(t),h=new CvPoint;h.x=Math.floor(r.width*Math.random()),h.y=Math.floor(r.height*Math.random());var o=new CvPoint;if(o.x=Math.floor(r.width*Math.random()),o.y=Math.floor(r.height*Math.random()),h.x!=o.x)for(var n=(h.y-o.y)/(h.x-o.x),i=0;i<r.height;i++)for(var e=0;e<r.width;e++){var v,w,d=(e+i*r.width)*CHANNELS,l=r.RGBA[0+d],f=r.RGBA[1+d],M=r.RGBA[2+d],g=i>n*(e-h.x)+h.y?(v=75,w=0,130):(v=0,w=255);r.RGBA[0+d]=.5*l+.5*v,r.RGBA[1+d]=.5*f+.5*w,r.RGBA[2+d]=.5*M+.5*g}var c=new CvScalar;c.r=c.g=c.b=255,cvLine(r,h,o,c,11,!1),cvShowImage(a,r)}catch(a){alert("fantasy_night : "+a)}}function ColorWave(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);cvThreshold(iplImage,newIplImage,128,255,CV_THRESHOLD_TYPE.THRESH_OTSU);var layer1=cvCreateImage(iplImage.width,iplImage.height);var layer2=cvCreateImage(iplImage.width,iplImage.height);var max=layer1.width*layer1.width+layer1.height*layer1.height;for(i=0;i<layer1.height;i++){for(j=0;j<layer1.width;j++){layer1.RGBA[(j+i*layer1.width)*CHANNELS]=255*i/(2*layer1.height);layer1.RGBA[1+(j+i*layer1.width)*CHANNELS]=255;layer1.RGBA[2+(j+i*layer1.width)*CHANNELS]=255;layer1.RGBA[3+(j+i*layer1.width)*CHANNELS]=255}} for(i=0;i<layer2.height;i++){for(j=0;j<layer2.width;j++){layer2.RGBA[(j+i*layer2.width)*CHANNELS]=255-255*i/(2*layer2.height);layer2.RGBA[1+(j+i*layer2.width)*CHANNELS]=255;layer2.RGBA[2+(j+i*layer2.width)*CHANNELS]=255;layer2.RGBA[3+(j+i*layer2.width)*CHANNELS]=255}} cvCvtColor(layer1,layer1,CV_CODE.HSV2RGB);cvCvtColor(layer2,layer2,CV_CODE.HSV2RGB);for(i=0;i<newIplImage.height;i++){for(j=0;j<newIplImage.width;j++){if(newIplImage.RGBA[(j+i*layer1.width)*CHANNELS]==255){newIplImage.RGBA[(j+i*layer1.width)*CHANNELS]=layer1.RGBA[(j+i*layer1.width)*CHANNELS];newIplImage.RGBA[1+(j+i*layer1.width)*CHANNELS]=layer1.RGBA[1+(j+i*layer1.width)*CHANNELS];newIplImage.RGBA[2+(j+i*layer1.width)*CHANNELS]=layer1.RGBA[2+(j+i*layer1.width)*CHANNELS]}else{newIplImage.RGBA[(j+i*layer1.width)*CHANNELS]=layer2.RGBA[(j+i*layer1.width)*CHANNELS];newIplImage.RGBA[1+(j+i*layer1.width)*CHANNELS]=layer2.RGBA[1+(j+i*layer1.width)*CHANNELS];newIplImage.RGBA[2+(j+i*layer1.width)*CHANNELS]=layer2.RGBA[2+(j+i*layer1.width)*CHANNELS]}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("ColorWave : "+ex)}} function Bilateral(imgId,iplImage){var newIplImage=cvCloneImage(iplImage);cvSmooth(iplImage,newIplImage,CV_SMOOTH_TYPE.BILATERAL);cvShowImage(imgId,newIplImage)} function Dilate(imgId,iplImage){var newIplImage=cvCloneImage(iplImage);cvCvtColor(iplImage,newIplImage,CV_CODE.RGB2GRAY);cvThreshold(newIplImage,newIplImage,128,255,CV_THRESHOLD_TYPE.THRESH_OTSU);cvDilate(newIplImage,newIplImage);cvShowImage(imgId,newIplImage)} function Smooth(imgId,iplImage){var newIplImage=cvCloneImage(iplImage);for(var i=0;i<10;i ++) cvSmooth(newIplImage,newIplImage,CV_SMOOTH_TYPE.BILATERAL);cvShowImage(imgId,newIplImage)}function Threshold(imgId,iplImage){var newIplImage=cvCloneImage(iplImage);cvThreshold(iplImage,newIplImage,128,255,CV_THRESHOLD_TYPE.THRESH_OTSU);cvShowImage(imgId,newIplImage)} function Sobel(imgId,iplImage){try{var dmyImage=cvCreateImage(iplImage.width,iplImage.height);var sobelXImage=cvCreateImage(iplImage.width,iplImage.height);var sobelYImage=cvCreateImage(iplImage.width,iplImage.height);cvCvtColor(iplImage,dmyImage,CV_CODE.RGB2GRAY);cvSobel(dmyImage,sobelXImage,1,0);cvSobel(dmyImage,sobelYImage,0,1);cvAdd(sobelXImage,sobelYImage,sobelXImage);cvConvertScaleAbs(sobelXImage,sobelXImage);cvShowImage(imgId,sobelXImage)}catch(ex){alert("Sobel : "+ex)}} function Canny(imgId,iplImage){try{var cannyImage=cvCreateImage(iplImage.width,iplImage.height);cvCvtColor(iplImage,cannyImage,CV_CODE.RGB2GRAY);cvCanny(cannyImage,cannyImage,50,80);cvShowImage(imgId,cannyImage)}catch(ex){alert("Canny : "+ex)}} function Vivid(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);cvCvtColor(iplImage,newIplImage,CV_CODE.RGB2HLS);for(i=0;i<newIplImage.height;i++){for(j=0;j<newIplImage.width;j++){newIplImage.RGBA[2+(j+i*newIplImage.width)*CHANNELS]=255}} cvCvtColor(newIplImage,newIplImage,CV_CODE.HLS2RGB);cvShowImage(imgId,newIplImage)}catch(ex){alert("Vivid : "+ex)}} function Sepia(imgId,iplImage){var HUE=22;var SATURATION=90;var newIplImage=cvCloneImage(iplImage);cvCvtColor(newIplImage,newIplImage,CV_CODE.RGB2HSV);for(i=0;i<newIplImage.height;i++){for(j=0;j<newIplImage.width;j++){newIplImage.RGBA[(j+i*newIplImage.width)*CHANNELS]=HUE;newIplImage.RGBA[1+(j+i*newIplImage.width)*CHANNELS]=SATURATION}} cvCvtColor(newIplImage,newIplImage,CV_CODE.HSV2RGB);cvShowImage(imgId,newIplImage)} function Amaro(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);var AMARO_RED_TONE_CURVE_UNDER_X=0;var AMARO_RED_TONE_CURVE_UNDER_Y=20;var AMARO_RED_TONE_CURVE_OVER_X=255;var AMARO_RED_TONE_CURVE_OVER_Y=255;var AMARO_GREEN_TONE_CURVE_UNDER_X=10;var AMARO_GREEN_TONE_CURVE_UNDER_Y=0;var AMARO_GREEN_TONE_CURVE_OVER_X=255;var AMARO_GREEN_TONE_CURVE_OVER_Y=255;var AMARO_BLUE_TONE_CURVE_UNDER_X=0;var AMARO_BLUE_TONE_CURVE_UNDER_Y=20;var AMARO_BLUE_TONE_CURVE_OVER_X=255;var AMARO_BLUE_TONE_CURVE_OVER_Y=255;cvToneCurve(newIplImage,newIplImage,AMARO_RED_TONE_CURVE_UNDER_X,AMARO_RED_TONE_CURVE_UNDER_Y,AMARO_RED_TONE_CURVE_OVER_X,AMARO_RED_TONE_CURVE_OVER_Y,0);cvToneCurve(newIplImage,newIplImage,AMARO_GREEN_TONE_CURVE_UNDER_X,AMARO_GREEN_TONE_CURVE_UNDER_Y,AMARO_GREEN_TONE_CURVE_OVER_X,AMARO_GREEN_TONE_CURVE_OVER_Y,1);cvToneCurve(newIplImage,newIplImage,AMARO_BLUE_TONE_CURVE_UNDER_X,AMARO_BLUE_TONE_CURVE_UNDER_Y,AMARO_BLUE_TONE_CURVE_OVER_X,AMARO_BLUE_TONE_CURVE_OVER_Y,2);cvShowImage(imgId,newIplImage)}catch(ex){alert("Amaro : "+ex)}} function WhiteBlack(imgId,iplImage){try{var UNDER=50;var OVER=150;var newIplImage=cvCloneImage(iplImage);cvCvtColor(iplImage,newIplImage,CV_CODE.RGB2GRAY);cvToneCurve(newIplImage,newIplImage,UNDER,0,OVER,255,0);cvToneCurve(newIplImage,newIplImage,UNDER,0,OVER,255,1);cvToneCurve(newIplImage,newIplImage,UNDER,0,OVER,255,2);cvShowImage(imgId,newIplImage)}catch(ex){alert("WhiteBlack : "+ex)}} function LightFall(imgId,iplImage){try{var power=255;var bunshi=80;var bunbo=100;var bairitsu=0.4;var lightWidth=iplImage.width*bairitsu;var lightHeight=iplImage.height*bairitsu;var lightImage=MakeLightImage(iplImage.width,iplImage.height,power,bunshi,bunbo,lightWidth,lightHeight);var newIplImage=cvCloneImage(iplImage);cvBlendImage(iplImage,lightImage,newIplImage,CV_BLEND_MODE.MUL);cvShowImage(imgId,newIplImage)}catch(ex){alert("LightFall : "+ex)}} function MakeLightImage(width,height,power,bunbo,bunshi,radiusX,radiusY){var iplImage=cvCreateImage(width,height);try{for(var i=0;i<height;i++){var y=i-height/2;for(var j=0;j<width;j++){var x=j-width/2;var v=power;var dis2=(y*y)/(radiusY*radiusY)+(x*x)/(radiusX*radiusX);if(dis2>1)v/=Math.pow(dis2,bunshi/bunbo);iplImage.RGBA[(j+i*width)*CHANNELS]=v;iplImage.RGBA[1+(j+i*width)*CHANNELS]=v;iplImage.RGBA[2+(j+i*width)*CHANNELS]=v;iplImage.RGBA[3+(j+i*width)*CHANNELS]=255}}}catch(ex){alert("MakeLightImage : "+ex)} return iplImage} function Invert(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=255-iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=255-iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=255-iplImage.RGBA[ji+2];newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Invert : "+ex)}} function Blur(imgId,iplImage){try{let newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(let i=0;i<iplImage.height;i++){for(let j=0;j<iplImage.width;j++){for(let c=0;c<3;c++){let sum=0;let count=0;for(let di=-1;di<=1;di++){for(let dj=-1;dj<=1;dj++){let ni=i+di;let nj=j+dj;if(ni>=0&&ni<iplImage.height&&nj>=0&&nj<iplImage.width){let index=((nj+ni*iplImage.width)*CHANNELS)+c;sum+=iplImage.RGBA[index];count++}}} let ji=(j+i*iplImage.width)*CHANNELS+c;newIplImage.RGBA[ji]=sum/count} newIplImage.RGBA[(j+i*iplImage.width)*CHANNELS+3]=iplImage.RGBA[(j+i*iplImage.width)*CHANNELS+3]}} cvShowImage(imgId,newIplImage)}catch(err){alert("Blur : "+err)}} function Sharpen(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let kernel=[0,-1,0,-1,5,-1,0,-1,0];for(let i=1;i<h-1;i++){for(let j=1;j<w-1;j++){for(let c=0;c<3;c++){let sum=0;for(let ki=-1;ki<=1;ki++){for(let kj=-1;kj<=1;kj++){let ni=i+ki,nj=j+kj;let index=((nj+ni*w)*CHANNELS)+c;let kVal=kernel[(ki+1)*3+(kj+1)];sum+=iplImage.RGBA[index]*kVal}} let dstIdx=((j+i*w)*CHANNELS)+c;newIplImage.RGBA[dstIdx]=Math.min(255,Math.max(0,sum))} newIplImage.RGBA[(j+i*w)*CHANNELS+3]=iplImage.RGBA[(j+i*w)*CHANNELS+3]}} cvShowImage(imgId,newIplImage)}catch(err){alert("Sharpen : "+err)}} function Emboss(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let kernel=[-2,-1,0,-1,1,1,0,1,2];for(let i=1;i<h-1;i++){for(let j=1;j<w-1;j++){for(let c=0;c<3;c++){let sum=0;for(let ki=-1;ki<=1;ki++){for(let kj=-1;kj<=1;kj++){let ni=i+ki,nj=j+kj;let index=((nj+ni*w)*CHANNELS)+c;let kVal=kernel[(ki+1)*3+(kj+1)];sum+=iplImage.RGBA[index]*kVal}} let dstIdx=((j+i*w)*CHANNELS)+c;newIplImage.RGBA[dstIdx]=Math.min(255,Math.max(0,sum+0))} newIplImage.RGBA[(j+i*w)*CHANNELS+3]=iplImage.RGBA[(j+i*w)*CHANNELS+3]}} cvShowImage(imgId,newIplImage)}catch(err){alert("Emboss : "+err)}} function Cartoon(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let src=new cv.Mat(h,w,cv.CV_8UC4);let dst=new cv.Mat();let gray=new cv.Mat();let edges=new cv.Mat();let color=new cv.Mat();let rgb=new cv.Mat();for(let i=0;i<h;i++){for(let j=0;j<w;j++){let idx=((j+i*w)*CHANNELS);let r=iplImage.RGBA[idx];let g=iplImage.RGBA[idx+1];let b=iplImage.RGBA[idx+2];src.ucharPtr(i,j)[0]=b;src.ucharPtr(i,j)[1]=g;src.ucharPtr(i,j)[2]=r;src.ucharPtr(i,j)[3]=iplImage.RGBA[idx+3]}} cv.cvtColor(src,rgb,cv.COLOR_RGBA2RGB);cv.cvtColor(rgb,gray,cv.COLOR_RGB2GRAY);cv.medianBlur(gray,gray,7);cv.adaptiveThreshold(gray,edges,255,cv.ADAPTIVE_THRESH_MEAN_C,cv.THRESH_BINARY,9,2);cv.bilateralFilter(rgb,color,9,75,75);cv.cvtColor(edges,edges,cv.COLOR_GRAY2RGB);cv.bitwise_and(color,edges,dst);cv.cvtColor(dst,dst,cv.COLOR_RGB2RGBA);for(let i=0;i<h;i++){for(let j=0;j<w;j++){let baseIdx=((j+i*w)*CHANNELS);let r=dst.ucharPtr(i,j)[2];let g=dst.ucharPtr(i,j)[1];let b=dst.ucharPtr(i,j)[0];let a=dst.ucharPtr(i,j)[3];newIplImage.RGBA[baseIdx]=r;newIplImage.RGBA[baseIdx+1]=g;newIplImage.RGBA[baseIdx+2]=b;newIplImage.RGBA[baseIdx+3]=a}} cvShowImage(imgId,newIplImage);src.delete();dst.delete();gray.delete();edges.delete();color.delete();rgb.delete()}catch(err){alert("Cartoon : "+err)}} function Smooth(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let src=new cv.Mat(h,w,cv.CV_8UC4);let dst=new cv.Mat();let gray=new cv.Mat();let color=new cv.Mat();let rgb=new cv.Mat();for(let i=0;i<h;i++){for(let j=0;j<w;j++){let idx=((j+i*w)*CHANNELS);let r=iplImage.RGBA[idx];let g=iplImage.RGBA[idx+1];let b=iplImage.RGBA[idx+2];src.ucharPtr(i,j)[0]=b;src.ucharPtr(i,j)[1]=g;src.ucharPtr(i,j)[2]=r;src.ucharPtr(i,j)[3]=iplImage.RGBA[idx+3]}} cv.cvtColor(src,rgb,cv.COLOR_RGBA2RGB);cv.cvtColor(rgb,gray,cv.COLOR_RGB2GRAY);cv.GaussianBlur(gray,gray,new cv.Size(15,15),0);cv.cvtColor(gray,gray,cv.COLOR_GRAY2RGB);cv.bilateralFilter(rgb,color,9,75,75);cv.bitwise_and(color,gray,dst);cv.cvtColor(dst,dst,cv.COLOR_RGB2RGBA);for(let i=0;i<h;i++){for(let j=0;j<w;j++){let baseIdx=((j+i*w)*CHANNELS);let r=dst.ucharPtr(i,j)[2];let g=dst.ucharPtr(i,j)[1];let b=dst.ucharPtr(i,j)[0];let a=dst.ucharPtr(i,j)[3];newIplImage.RGBA[baseIdx]=r;newIplImage.RGBA[baseIdx+1]=g;newIplImage.RGBA[baseIdx+2]=b;newIplImage.RGBA[baseIdx+3]=a}} cvShowImage(imgId,newIplImage);src.delete();dst.delete();gray.delete();color.delete();rgb.delete()}catch(err){alert("Smooth : "+err)}} function Smooth_GaussianBlur(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let src=new cv.Mat(h,w,cv.CV_8UC4);let dst=new cv.Mat();let rgb=new cv.Mat();for(let i=0;i<h;i++){for(let j=0;j<w;j++){let idx=((j+i*w)*CHANNELS);let r=iplImage.RGBA[idx];let g=iplImage.RGBA[idx+1];let b=iplImage.RGBA[idx+2];src.ucharPtr(i,j)[0]=b;src.ucharPtr(i,j)[1]=g;src.ucharPtr(i,j)[2]=r;src.ucharPtr(i,j)[3]=iplImage.RGBA[idx+3]}} cv.cvtColor(src,rgb,cv.COLOR_RGBA2RGB);cv.GaussianBlur(rgb,dst,new cv.Size(15,15),0);cv.cvtColor(dst,dst,cv.COLOR_RGB2RGBA);for(let i=0;i<h;i++){for(let j=0;j<w;j++){let baseIdx=((j+i*w)*CHANNELS);let r=dst.ucharPtr(i,j)[2];let g=dst.ucharPtr(i,j)[1];let b=dst.ucharPtr(i,j)[0];let a=dst.ucharPtr(i,j)[3];newIplImage.RGBA[baseIdx]=r;newIplImage.RGBA[baseIdx+1]=g;newIplImage.RGBA[baseIdx+2]=b;newIplImage.RGBA[baseIdx+3]=a}} cvShowImage(imgId,newIplImage);src.delete();dst.delete();rgb.delete()}catch(err){alert("Smooth_GaussianBlur : "+err)}}function Smooth_MedianBlur(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let src=new cv.Mat(h,w,cv.CV_8UC4);let dst=new cv.Mat();let rgb=new cv.Mat();for(let i=0;i<h;i++){for(let j=0;j<w;j++){let idx=((j+i*w)*CHANNELS);let r=iplImage.RGBA[idx];let g=iplImage.RGBA[idx+1];let b=iplImage.RGBA[idx+2];src.ucharPtr(i,j)[0]=b;src.ucharPtr(i,j)[1]=g;src.ucharPtr(i,j)[2]=r;src.ucharPtr(i,j)[3]=iplImage.RGBA[idx+3]}} cv.cvtColor(src,rgb,cv.COLOR_RGBA2RGB);cv.medianBlur(rgb,dst,5);cv.cvtColor(dst,dst,cv.COLOR_RGB2RGBA);for(let i=0;i<h;i++){for(let j=0;j<w;j++){let baseIdx=((j+i*w)*CHANNELS);let r=dst.ucharPtr(i,j)[2];let g=dst.ucharPtr(i,j)[1];let b=dst.ucharPtr(i,j)[0];let a=dst.ucharPtr(i,j)[3];newIplImage.RGBA[baseIdx]=r;newIplImage.RGBA[baseIdx+1]=g;newIplImage.RGBA[baseIdx+2]=b;newIplImage.RGBA[baseIdx+3]=a}} cvShowImage(imgId,newIplImage);src.delete();dst.delete();rgb.delete()}catch(err){alert("Smooth_MedianBlur : "+err)}} function Smooth_AveragingFilter(imgId,iplImage){try{let w=iplImage.width,h=iplImage.height;let newIplImage=cvCreateImage(w,h);let src=new cv.Mat(h,w,cv.CV_8UC4);let dst=new cv.Mat();let rgb=new cv.Mat();for(let i=0;i<h;i++){for(let j=0;j<w;j++){let idx=((j+i*w)*CHANNELS);let r=iplImage.RGBA[idx];let g=iplImage.RGBA[idx+1];let b=iplImage.RGBA[idx+2];src.ucharPtr(i,j)[0]=b;src.ucharPtr(i,j)[1]=g;src.ucharPtr(i,j)[2]=r;src.ucharPtr(i,j)[3]=iplImage.RGBA[idx+3]}} cv.cvtColor(src,rgb,cv.COLOR_RGBA2RGB);cv.blur(rgb,dst,new cv.Size(5,5));cv.cvtColor(dst,dst,cv.COLOR_RGB2RGBA);for(let i=0;i<h;i++){for(let j=0;j<w;j++){let baseIdx=((j+i*w)*CHANNELS);let r=dst.ucharPtr(i,j)[2];let g=dst.ucharPtr(i,j)[1];let b=dst.ucharPtr(i,j)[0];let a=dst.ucharPtr(i,j)[3];newIplImage.RGBA[baseIdx]=r;newIplImage.RGBA[baseIdx+1]=g;newIplImage.RGBA[baseIdx+2]=b;newIplImage.RGBA[baseIdx+3]=a}} cvShowImage(imgId,newIplImage);src.delete();dst.delete();rgb.delete()}catch(err){alert("Smooth_AveragingFilter : "+err)}} function SVM(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var threshold=128;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var brightness=0.2126*iplImage.RGBA[ji]+0.7152*iplImage.RGBA[ji+1]+0.0722*iplImage.RGBA[ji+2];if(brightness>threshold){newIplImage.RGBA[ji]=255;newIplImage.RGBA[ji+1]=255;newIplImage.RGBA[ji+2]=255}else{newIplImage.RGBA[ji]=0;newIplImage.RGBA[ji+1]=0;newIplImage.RGBA[ji+2]=0} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("SVM : "+ex)}} function Perceptron(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var weightR=0.3,weightG=0.59,weightB=0.11;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var net=weightR*iplImage.RGBA[ji]+weightG*iplImage.RGBA[ji+1]+weightB*iplImage.RGBA[ji+2];if(net>128){newIplImage.RGBA[ji]=255;newIplImage.RGBA[ji+1]=0;newIplImage.RGBA[ji+2]=0}else{newIplImage.RGBA[ji]=iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Perceptron : "+ex)}} function PerceptronGreen(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var weightR=0.3,weightG=0.59,weightB=0.11;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var net=weightR*iplImage.RGBA[ji]+weightG*iplImage.RGBA[ji+1]+weightB*iplImage.RGBA[ji+2];if(net>128){newIplImage.RGBA[ji]=0;newIplImage.RGBA[ji+1]=255;newIplImage.RGBA[ji+2]=0}else{newIplImage.RGBA[ji]=iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("PerceptronGreen : "+ex)}} function PerceptronBlue(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var weightR=0.3,weightG=0.59,weightB=0.11;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var net=weightR*iplImage.RGBA[ji]+weightG*iplImage.RGBA[ji+1]+weightB*iplImage.RGBA[ji+2];if(net>128){newIplImage.RGBA[ji]=0;newIplImage.RGBA[ji+1]=0;newIplImage.RGBA[ji+2]=255}else{newIplImage.RGBA[ji]=iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("PerceptronBlue : "+ex)}} function PerceptronPurple(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var weightR=0.3,weightG=0.59,weightB=0.11;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var net=weightR*iplImage.RGBA[ji]+weightG*iplImage.RGBA[ji+1]+weightB*iplImage.RGBA[ji+2];if(net>128){newIplImage.RGBA[ji]=255;newIplImage.RGBA[ji+1]=0;newIplImage.RGBA[ji+2]=255}else{newIplImage.RGBA[ji]=iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("PerceptronPurple : "+ex)}} function PerceptronYellow(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var weightR=0.3,weightG=0.59,weightB=0.11;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var net=weightR*iplImage.RGBA[ji]+weightG*iplImage.RGBA[ji+1]+weightB*iplImage.RGBA[ji+2];if(net>128){newIplImage.RGBA[ji]=255;newIplImage.RGBA[ji+1]=255;newIplImage.RGBA[ji+2]=0}else{newIplImage.RGBA[ji]=iplImage.RGBA[ji];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("PerceptronYellow : "+ex)}} function Grayscale(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var gray=Math.round(0.299*r+0.587*g+0.114*b);newIplImage.RGBA[ji]=gray;newIplImage.RGBA[ji+1]=gray;newIplImage.RGBA[ji+2]=gray;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Grayscale : "+ex)}}function HandmadePaperStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=Math.min(iplImage.RGBA[ji]*1.1+15,255);var g=Math.min(iplImage.RGBA[ji+1]*1.1+15,255);var b=Math.min(iplImage.RGBA[ji+2]*1.1+15,255);var noise=(Math.random()-0.5)*20;newIplImage.RGBA[ji]=Math.min(Math.max(r+noise,0),255);newIplImage.RGBA[ji+1]=Math.min(Math.max(g+noise,0),255);newIplImage.RGBA[ji+2]=Math.min(Math.max(b+noise,0),255);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HandmadePaperStyle : "+ex)}} function DotPixelStyle01(imgId,iplImage){try{const blockSize=6;var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(let y=0;y<iplImage.height;y+=blockSize){for(let x=0;x<iplImage.width;x+=blockSize){let rSum=0,gSum=0,bSum=0,count=0;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;rSum+=iplImage.RGBA[index];gSum+=iplImage.RGBA[index+1];bSum+=iplImage.RGBA[index+2];count++}} const rAvg=rSum/count;const gAvg=gSum/count;const bAvg=bSum/count;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;newIplImage.RGBA[index]=rAvg;newIplImage.RGBA[index+1]=gAvg;newIplImage.RGBA[index+2]=bAvg;newIplImage.RGBA[index+3]=255}}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("DotPixelStyle : "+ex)}} function DotPixelStyle02(imgId,iplImage){try{const blockSize=10;var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(let y=0;y<iplImage.height;y+=blockSize){for(let x=0;x<iplImage.width;x+=blockSize){let rSum=0,gSum=0,bSum=0,count=0;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;rSum+=iplImage.RGBA[index];gSum+=iplImage.RGBA[index+1];bSum+=iplImage.RGBA[index+2];count++}} const rAvg=rSum/count;const gAvg=gSum/count;const bAvg=bSum/count;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;newIplImage.RGBA[index]=rAvg;newIplImage.RGBA[index+1]=gAvg;newIplImage.RGBA[index+2]=bAvg;newIplImage.RGBA[index+3]=255}}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("DotPixelStyle : "+ex)}} function DotPixelStyle03(imgId,iplImage){try{const blockSize=15;var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(let y=0;y<iplImage.height;y+=blockSize){for(let x=0;x<iplImage.width;x+=blockSize){let rSum=0,gSum=0,bSum=0,count=0;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;rSum+=iplImage.RGBA[index];gSum+=iplImage.RGBA[index+1];bSum+=iplImage.RGBA[index+2];count++}} const rAvg=rSum/count;const gAvg=gSum/count;const bAvg=bSum/count;for(let dy=0;dy<blockSize;dy++){for(let dx=0;dx<blockSize;dx++){const xx=x+dx,yy=y+dy;if(xx>=iplImage.width||yy>=iplImage.height)continue;const index=(xx+yy*iplImage.width)*CHANNELS;newIplImage.RGBA[index]=rAvg;newIplImage.RGBA[index+1]=gAvg;newIplImage.RGBA[index+2]=bAvg;newIplImage.RGBA[index+3]=255}}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("DotPixelStyle : "+ex)}} function KirieStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=1;i<iplImage.height-1;i++){for(var j=1;j<iplImage.width-1;j++){var ji=(j+i*iplImage.width)*CHANNELS;var center=(iplImage.RGBA[ji]+iplImage.RGBA[ji+1]+iplImage.RGBA[ji+2])/3;var sumDiff=0;for(var dy=-1;dy<=1;dy++){for(var dx=-1;dx<=1;dx++){if(dx===0&&dy===0)continue;var neighbor=((j+dx)+(i+dy)*iplImage.width)*CHANNELS;var neighborGray=(iplImage.RGBA[neighbor]+iplImage.RGBA[neighbor+1]+iplImage.RGBA[neighbor+2])/3;sumDiff+=Math.abs(center-neighborGray)}} var r=Math.floor(iplImage.RGBA[ji]/85)*85+42;var g=Math.floor(iplImage.RGBA[ji+1]/85)*85+42;var b=Math.floor(iplImage.RGBA[ji+2]/85)*85+42;if(sumDiff>120){newIplImage.RGBA[ji]=30;newIplImage.RGBA[ji+1]=30;newIplImage.RGBA[ji+2]=30}else{newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("KirieStyle : "+ex)}}function SketchHandDrawnStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=1;i<iplImage.height-1;i++){for(var j=1;j<iplImage.width-1;j++){var ji=(j+i*iplImage.width)*CHANNELS;var gx=0,gy=0;for(var dy=-1;dy<=1;dy++){for(var dx=-1;dx<=1;dx++){var neighbor=((j+dx)+(i+dy)*iplImage.width)*CHANNELS;var gray=(iplImage.RGBA[neighbor]+iplImage.RGBA[neighbor+1]+iplImage.RGBA[neighbor+2])/3;var weightX=dx;var weightY=dy;gx+=gray*weightX;gy+=gray*weightY}} var edge=255-Math.min(Math.sqrt(gx*gx+gy*gy),255);newIplImage.RGBA[ji]=edge;newIplImage.RGBA[ji+1]=edge;newIplImage.RGBA[ji+2]=edge;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("SketchHandDrawnStyle : "+ex)}}function SketchHandDrawnStyle02(t,a){try{for(var r=cvCreateImage(a.width,a.height),h=1;h<a.height-1;h++)for(var e=1;e<a.width-1;e++){for(var i=(e+h*a.width)*CHANNELS,v=0,c=0,n=-1;n<=1;n++)for(var o=-1;o<=1;o++){var w=(e+o+(h+n)*a.width)*CHANNELS,w=(a.RGBA[w]+a.RGBA[1+w]+a.RGBA[2+w])/3;v+=o*w,c+=n*w}for(var A=255-Math.min(1.2*Math.sqrt(v*v+c*c),255),S=0;S<3;S++)r.RGBA[i+S]=A;r.RGBA[3+i]=255}cvShowImage(t,r)}catch(t){alert("SketchHandDrawnStyle02 : "+t)}}function SketchHandDrawnStyle03(t,a){try{for(var r=cvCreateImage(a.width,a.height),h=1;h<a.height-1;h++)for(var e=1;e<a.width-1;e++){for(var i=(e+h*a.width)*CHANNELS,v=0,c=0,n=-1;n<=1;n++)for(var o=-1;o<=1;o++){var w=(e+o+(h+n)*a.width)*CHANNELS,w=(a.RGBA[w]+a.RGBA[1+w]+a.RGBA[2+w])/3;v+=o*w,c+=n*w}for(var A=255-Math.min(2*Math.sqrt(v*v+c*c),255),S=0;S<3;S++)r.RGBA[i+S]=A;r.RGBA[3+i]=255}cvShowImage(t,r)}catch(t){alert("SketchHandDrawnStyle02 : "+t)}}function ArtFilterStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var avg=(r+g+b)/3;if(avg>200)avg=255;else if(avg>100)avg=180;else avg=80;newIplImage.RGBA[ji]=avg;newIplImage.RGBA[ji+1]=avg*0.9;newIplImage.RGBA[ji+2]=avg*0.7;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("ArtFilterStyle : "+ex)}} function NightGlowStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var brightness=(r+g+b)/3;if(brightness>180){r=Math.min(255,r*1.3);g=Math.min(255,g*1.2);b=Math.min(255,b*1.4)}else{r=r*0.5;g=g*0.5;b=b*0.6} newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("NightGlowStyle : "+ex)}} function TiltShiftStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var height=iplImage.height;for(var i=0;i<height;i++){var blurFactor=Math.abs((i-height/2)/(height/2));blurFactor=Math.min(1,blurFactor*1.5);for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];r=r*(1-blurFactor)+128*blurFactor;g=g*(1-blurFactor)+128*blurFactor;b=b*(1-blurFactor)+128*blurFactor;newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("TiltShiftStyle : "+ex)}} function AnaglyphStyle(imgId,iplImage){try{var offset=5;var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var redIndex=((j-offset+iplImage.width)%iplImage.width+i*iplImage.width)*CHANNELS;var cyanIndex=((j+offset)%iplImage.width+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[redIndex];var g=iplImage.RGBA[cyanIndex+1];var b=iplImage.RGBA[cyanIndex+2];newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("AnaglyphStyle : "+ex)}} function WatercolorStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji]*0.9;var g=iplImage.RGBA[ji+1]*0.95;var b=iplImage.RGBA[ji+2]*1.05;var brightness=20;r=Math.min(255,r+brightness);g=Math.min(255,g+brightness);b=Math.min(255,b+brightness);newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("WatercolorStyle : "+ex)}} function HalftoneStyle(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=a%4+i%4<(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3/255*4*2?255:0;h.RGBA[r]=A,h.RGBA[1+r]=A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("HalftoneStyle : "+t)}}function HalftoneStyle02(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=a%8+i%8<(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3/255*8*2?255:0;h.RGBA[r]=A,h.RGBA[1+r]=A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("HalftoneStyle02 : "+t)}}function HalftoneStyle03(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=a%12+i%12<(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3/255*12*2?255:0;h.RGBA[r]=A,h.RGBA[1+r]=A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("HalftoneStyle03 : "+t)}}function HalftoneStyle04(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=(a+i)%10<(128<(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3?5:3)?255:0;h.RGBA[r]=A,h.RGBA[1+r]=A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("HalftoneStyle04 : "+t)}}function BlueSketchStyle(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3;h.RGBA[r]=.5*A,h.RGBA[1+r]=.6*A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("BlueSketchStyle : "+t)}}function DotMatrixStyle(t,e){try{for(var h=cvCreateImage(e.width,e.height),a=0;a<e.height;a++)for(var i=0;i<e.width;i++){var r=(i+a*e.width)*CHANNELS,A=(e.RGBA[r]+e.RGBA[1+r]+e.RGBA[2+r])/3,A=i%6==0&&a%6==0?A:.6*A;h.RGBA[r]=A,h.RGBA[1+r]=A,h.RGBA[2+r]=A,h.RGBA[3+r]=e.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("DotMatrixStyle : "+t)}}function GlowEdgesStyle01(t,a){try{var i=cvCreateImage(a.width,a.height);let h=cvCreateImage(a.width,a.height);cvSobel(a,i,1,0,3);for(let e=0;e<a.height;e++)for(let t=0;t<a.width;t++){var r=(t+e*a.width)*CHANNELS,A=i.RGBA[r],G=i.RGBA[1+r],B=i.RGBA[2+r];h.RGBA[r]=Math.min(255,.6*A),h.RGBA[1+r]=Math.min(255,.2*G),h.RGBA[2+r]=Math.min(255,B+100),h.RGBA[3+r]=255}cvShowImage(t,h)}catch(t){alert("GlowEdgesStyle01 : "+t)}}function GlowEdgesStyle02(t,a){try{var i=cvCreateImage(a.width,a.height);let h=cvCreateImage(a.width,a.height);cvSobel(a,i,0,1,3);for(let e=0;e<a.height;e++)for(let t=0;t<a.width;t++){var r=(t+e*a.width)*CHANNELS,A=i.RGBA[r],G=i.RGBA[1+r],B=i.RGBA[2+r];h.RGBA[r]=Math.min(255,.6*A),h.RGBA[1+r]=Math.min(255,.2*G),h.RGBA[2+r]=Math.min(255,B+100),h.RGBA[3+r]=255}cvShowImage(t,h)}catch(t){alert("GlowEdgesStyle02 : "+t)}}function GlowEdgesStyle03(t,i){try{var r=cvCreateImage(i.width,i.height),A=cvCreateImage(i.width,i.height);let h=cvCreateImage(i.width,i.height),a=cvCreateImage(i.width,i.height);cvSobel(i,r,1,0,3),cvSobel(i,A,0,1,3);for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var G=(t+e*h.width)*CHANNELS;for(let t=0;t<3;t++)h.RGBA[G+t]=Math.min(255,r.RGBA[G+t]+A.RGBA[G+t]);h.RGBA[3+G]=255}for(let e=0;e<i.height;e++)for(let t=0;t<i.width;t++){var B=(t+e*i.width)*CHANNELS,R=h.RGBA[B],l=h.RGBA[1+B],g=h.RGBA[2+B];a.RGBA[B]=Math.min(255,.6*R),a.RGBA[1+B]=Math.min(255,.2*l),a.RGBA[2+B]=Math.min(255,g+100),a.RGBA[3+B]=255}cvShowImage(t,a)}catch(t){alert("GlowEdgesStyle03 : "+t)}}function GlowEdgesStyle04(t,i){try{var r=cvCreateImage(i.width,i.height),A=cvCreateImage(i.width,i.height);let h=cvCreateImage(i.width,i.height),a=cvCreateImage(i.width,i.height);cvSobel(i,r,1,0,3),cvSobel(i,A,0,1,3);for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var G=(t+e*h.width)*CHANNELS;for(let t=0;t<3;t++)h.RGBA[G+t]=Math.min(255,r.RGBA[G+t]+A.RGBA[G+t]);h.RGBA[3+G]=255}for(let e=0;e<i.height;e++)for(let t=0;t<i.width;t++){var B=(t+e*i.width)*CHANNELS,R=h.RGBA[B],l=h.RGBA[1+B],g=h.RGBA[2+B];a.RGBA[B]=Math.min(255,.3*R),a.RGBA[1+B]=Math.min(255,.5*l+30),a.RGBA[2+B]=Math.min(255,1.2*g+50)}cvShowImage(t,a)}catch(t){alert("GlowEdgesStyle04 : "+t)}}function GlowEdgesStyle05(t,i){try{var r=cvCreateImage(i.width,i.height),A=cvCreateImage(i.width,i.height);let h=cvCreateImage(i.width,i.height),a=cvCreateImage(i.width,i.height);cvSobel(i,r,1,0,3),cvSobel(i,A,0,1,3);for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var G=(t+e*h.width)*CHANNELS;for(let t=0;t<3;t++)h.RGBA[G+t]=Math.min(255,r.RGBA[G+t]+A.RGBA[G+t]);h.RGBA[3+G]=255}for(let e=0;e<i.height;e++)for(let t=0;t<i.width;t++){var B=(t+e*i.width)*CHANNELS,R=h.RGBA[B],l=h.RGBA[1+B],g=h.RGBA[2+B];a.RGBA[B]=Math.min(255,+R+30),a.RGBA[1+B]=Math.min(255,+l+30),a.RGBA[2+B]=Math.min(255,+g+30)}cvShowImage(t,a)}catch(t){alert("GlowEdgesStyle05 : "+t)}}function GlowEdgesStyle06(t,i){try{var r=cvCreateImage(i.width,i.height),A=cvCreateImage(i.width,i.height);let h=cvCreateImage(i.width,i.height),a=cvCreateImage(i.width,i.height);cvSobel(i,r,1,0,3),cvSobel(i,A,0,1,3);for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var G=(t+e*h.width)*CHANNELS;for(let t=0;t<3;t++)h.RGBA[G+t]=Math.min(255,r.RGBA[G+t]+A.RGBA[G+t]);h.RGBA[3+G]=255}for(let e=0;e<i.height;e++)for(let t=0;t<i.width;t++){var B=(t+e*i.width)*CHANNELS,R=h.RGBA[B],l=h.RGBA[1+B],g=h.RGBA[2+B];a.RGBA[B]=Math.min(255,1.1*R+50),a.RGBA[1+B]=Math.min(255,.8*l+20),a.RGBA[2+B]=Math.min(255,.2*g)}cvShowImage(t,a)}catch(t){alert("GlowEdgesStyle06 : "+t)}}function GlowEdgesStyle07(t,i){try{var r=cvCreateImage(i.width,i.height),A=cvCreateImage(i.width,i.height);let h=cvCreateImage(i.width,i.height),a=cvCreateImage(i.width,i.height);cvSobel(i,r,1,0,3),cvSobel(i,A,0,1,3);for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var G=(t+e*h.width)*CHANNELS;for(let t=0;t<3;t++)h.RGBA[G+t]=Math.min(255,r.RGBA[G+t]+A.RGBA[G+t]);h.RGBA[3+G]=255}for(let e=0;e<i.height;e++)for(let t=0;t<i.width;t++){var B=(t+e*i.width)*CHANNELS,R=h.RGBA[B],l=h.RGBA[1+B],g=h.RGBA[2+B];a.RGBA[B]=Math.min(255,.5*R+40),a.RGBA[1+B]=Math.min(255,.5*l+40),a.RGBA[2+B]=Math.min(255,.5*g+40)}cvShowImage(t,a)}catch(t){alert("GlowEdgesStyle07 : "+t)}}function EmbossGlowEdges(t,h){try{var a=cvCreateImage(h.width,h.height),i=cvCreateImage(h.width,h.height);const c=cvCreateImage(h.width,h.height),w=cvCreateImage(h.width,h.height);cvSobel(h,a,1,0,3),cvSobel(h,i,0,1,3);for(let e=0;e<c.height;e++)for(let t=0;t<c.width;t++){var r=(t+e*c.width)*CHANNELS;for(let t=0;t<3;t++)c.RGBA[r+t]=Math.min(255,a.RGBA[r+t]+i.RGBA[r+t]);c.RGBA[3+r]=255}for(let e=0;e<h.height;e++)for(let t=0;t<h.width;t++){var A=(t+e*h.width)*CHANNELS,G=h.RGBA[A],B=h.RGBA[1+A],R=h.RGBA[2+A],l=c.RGBA[A],g=c.RGBA[1+A],o=c.RGBA[2+A],l=Math.min(255,l+80),g=Math.min(255,g+40),o=Math.min(255,.1*o);w.RGBA[A]=Math.min(255,.8*G+.4*l),w.RGBA[1+A]=Math.min(255,.8*B+.4*g),w.RGBA[2+A]=Math.min(255,.8*R+.4*o),w.RGBA[3+A]=255}cvShowImage(t,w)}catch(t){alert("EmbossGlowEdges : "+t)}} function LensFlareStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var cx=iplImage.width*0.8;var cy=iplImage.height*0.2;var radius=iplImage.width*0.15;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var dx=j-cx;var dy=i-cy;var dist=Math.sqrt(dx*dx+dy*dy);var flare=dist<radius?1-(dist/radius):0;var r=iplImage.RGBA[ji]+255*flare*0.5;var g=iplImage.RGBA[ji+1]+255*flare*0.4;var b=iplImage.RGBA[ji+2]+255*flare*0.2;newIplImage.RGBA[ji]=Math.min(255,r);newIplImage.RGBA[ji+1]=Math.min(255,g);newIplImage.RGBA[ji+2]=Math.min(255,b);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("LensFlareStyle : "+ex)}} function LightLeak_left(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var width=iplImage.width;var height=iplImage.height;for(var i=0;i<height;i++){for(var j=0;j<width;j++){var ji=(j+i*width)*CHANNELS;var leak=Math.max(0,1-j/(width*0.5));var r=iplImage.RGBA[ji]+100*leak;var g=iplImage.RGBA[ji+1]+50*leak;var b=iplImage.RGBA[ji+2];newIplImage.RGBA[ji]=Math.min(255,r);newIplImage.RGBA[ji+1]=Math.min(255,g);newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("LightLeak_left : "+ex)}} function LightLeak_right(t,h){try{for(var a=cvCreateImage(h.width,h.height),i=h.width,r=h.height,e=0;e<r;e++)for(var A=0;A<i;A++){var g=(A+e*i)*CHANNELS,B=Math.max(0,1-(i-A)/(.5*i)),G=h.RGBA[g]+100*B,R=h.RGBA[1+g]+50*B,B=h.RGBA[2+g];a.RGBA[g]=Math.min(255,G),a.RGBA[1+g]=Math.min(255,R),a.RGBA[2+g]=B,a.RGBA[3+g]=h.RGBA[3+g]}cvShowImage(t,a)}catch(t){alert("LightLeak_right : "+t)}}function LightLeak_TopLeft(t,a){try{for(var h=cvCreateImage(a.width,a.height),e=a.width,i=a.height,r=0;r<i;r++)for(var A=0;A<e;A++){var B=(A+r*e)*CHANNELS,G=Math.max(0,1-Math.sqrt(A*A+r*r)/(.7*e)),R=a.RGBA[B]+120*G,L=a.RGBA[1+B]+70*G,G=a.RGBA[2+B];h.RGBA[B]=Math.min(255,R),h.RGBA[1+B]=Math.min(255,L),h.RGBA[2+B]=G,h.RGBA[3+B]=a.RGBA[3+B]}cvShowImage(t,h)}catch(t){alert("LightLeak_TopLeft : "+t)}}function LightLeak_Diagonal(a,t){try{for(var h=cvCreateImage(t.width,t.height),i=t.width,e=t.height,r=0;r<e;r++)for(var A=0;A<i;A++){var g=(A+r*i)*CHANNELS,B=i-A,G=e-r,R=Math.sqrt(B*B+G*G),B=Math.max(0,1-R/(.8*i)),G=t.RGBA[g]+100*B,R=t.RGBA[1+g]+60*B,B=t.RGBA[2+g];h.RGBA[g]=Math.min(255,G),h.RGBA[1+g]=Math.min(255,R),h.RGBA[2+g]=B,h.RGBA[3+g]=t.RGBA[3+g]}cvShowImage(a,h)}catch(a){alert("LightLeak_Diagonal : "+a)}}function LensFlareEffect(t,a){try{for(var e=cvCreateImage(a.width,a.height),h=a.width,r=a.height,A=.5*h,i=.5*r,B=0;B<r;B++)for(var G=0;G<h;G++){var R=(G+B*h)*CHANNELS,c=G-A,f=B-i,n=Math.sqrt(c*c+f*f),c=Math.max(0,1-n/(.5*h)),f=a.RGBA[R]+150*c,n=a.RGBA[1+R]+100*c,c=a.RGBA[2+R]+50*c;e.RGBA[R]=Math.min(255,f),e.RGBA[1+R]=Math.min(255,n),e.RGBA[2+R]=Math.min(255,c),e.RGBA[3+R]=a.RGBA[3+R]}cvShowImage(t,e)}catch(t){alert("LensFlareEffect : "+t)}} function WarmLightTopLeft(t,a){try{for(var h=cvCreateImage(a.width,a.height),r=a.width,i=a.height,e=0;e<i;e++)for(var A=0;A<r;A++){var m=(A+e*r)*CHANNELS,B=Math.sqrt(A*A+e*e),G=Math.max(0,1-B/(.7*r)),R=a.RGBA[m]+180*G,B=a.RGBA[1+m]+100*G,G=a.RGBA[2+m]+30*G;h.RGBA[m]=Math.min(255,R),h.RGBA[1+m]=Math.min(255,B),h.RGBA[2+m]=Math.min(255,G),h.RGBA[3+m]=a.RGBA[3+m]}cvShowImage(t,h)}catch(t){alert("WarmLightTopLeft : "+t)}} function CoolLightTopRight(t,h){try{for(var a=cvCreateImage(h.width,h.height),i=h.width,o=h.height,R=0;R<o;R++)for(var r=0;r<i;r++){var A=(r+R*i)*CHANNELS,g=i-r,B=Math.sqrt(g*g+R*R),G=Math.max(0,1-B/(.7*i)),g=h.RGBA[A]+20*G,B=h.RGBA[1+A]+50*G,G=h.RGBA[2+A]+160*G;a.RGBA[A]=Math.min(255,g),a.RGBA[1+A]=Math.min(255,B),a.RGBA[2+A]=Math.min(255,G),a.RGBA[3+A]=h.RGBA[3+A]}cvShowImage(t,a)}catch(t){alert("CoolLightTopRight : "+t)}} function SunsetGlowBottomLeft(t,a){try{for(var h=cvCreateImage(a.width,a.height),e=a.width,o=a.height,B=0;B<o;B++)for(var G=0;G<e;G++){var r=(G+B*e)*CHANNELS,A=o-B,i=Math.sqrt(G*G+A*A),m=Math.max(0,1-i/(.7*e)),A=a.RGBA[r]+160*m,i=a.RGBA[1+r]+90*m,m=a.RGBA[2+r]+40*m;h.RGBA[r]=Math.min(255,A),h.RGBA[1+r]=Math.min(255,i),h.RGBA[2+r]=Math.min(255,m),h.RGBA[3+r]=a.RGBA[3+r]}cvShowImage(t,h)}catch(t){alert("SunsetGlowBottomLeft : "+t)}} function RandomBokehLight(a,h){try{for(var t=cvCloneImage(h),o=h.width,r=h.height,m=0;m<15;m++)for(var M=Math.floor(Math.random()*o),n=Math.floor(Math.random()*r),i=Math.floor(30*Math.random()+20),B=.6*Math.random()+.4,R=Math.max(0,n-i);R<Math.min(r,n+i);R++)for(var d=Math.max(0,M-i);d<Math.min(o,M+i);d++){var e=(d+R*o)*CHANNELS,f=d-M,A=R-n,A=Math.sqrt(f*f+A*A);A<i&&(A=B*(1-A/i),t.RGBA[e]=Math.min(255,t.RGBA[e]+180*A),t.RGBA[1+e]=Math.min(255,t.RGBA[1+e]+180*A),t.RGBA[2+e]=Math.min(255,t.RGBA[2+e]+180*A))}cvShowImage(a,t)}catch(a){alert("RandomBokehLight : "+a)}} function SepiaNoise(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var tr=Math.min((0.393*r+0.769*g+0.189*b),255);var tg=Math.min((0.349*r+0.686*g+0.168*b),255);var tb=Math.min((0.272*r+0.534*g+0.131*b),255);var noise=Math.floor(Math.random()*41)-20;newIplImage.RGBA[ji]=Math.max(Math.min(tr+noise,255),0);newIplImage.RGBA[ji+1]=Math.max(Math.min(tg+noise,255),0);newIplImage.RGBA[ji+2]=Math.max(Math.min(tb+noise,255),0);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("SepiaNoise : "+ex)}} function OldPhoto(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var fade=0.6;var tr=Math.min((r*0.9+g*0.4+b*0.2)*fade,255);var tg=Math.min((r*0.5+g*0.6+b*0.1)*fade,255);var tb=Math.min((r*0.2+g*0.3+b*0.5)*fade,255);newIplImage.RGBA[ji]=tr;newIplImage.RGBA[ji+1]=tg;newIplImage.RGBA[ji+2]=tb;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("OldPhoto : "+ex)}} function LaplacianEdge(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var y=1;y<iplImage.height-1;y++){for(var x=1;x<iplImage.width-1;x++){var sum=0;for(var ky=-1;ky<=1;ky++){for(var kx=-1;kx<=1;kx++){var px=x+kx;var py=y+ky;var index=(px+py*iplImage.width)*CHANNELS;var gray=(iplImage.RGBA[index]+iplImage.RGBA[index+1]+iplImage.RGBA[index+2])/3;var weight=(kx===0&&ky===0)?8:-1;sum+=gray*weight}} sum=Math.max(0,Math.min(255,sum));var outIdx=(x+y*iplImage.width)*CHANNELS;newIplImage.RGBA[outIdx]=sum;newIplImage.RGBA[outIdx+1]=sum;newIplImage.RGBA[outIdx+2]=sum;newIplImage.RGBA[outIdx+3]=255}} cvShowImage(imgId,newIplImage)}catch(ex){alert("LaplacianEdge : "+ex)}} function HueShift(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+2];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji];newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HueShift : "+ex)}} function HueShift1(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=iplImage.RGBA[ji+2];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HueShift1 : "+ex)}} function HueShift2(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=iplImage.RGBA[ji+1];newIplImage.RGBA[ji+1]=iplImage.RGBA[ji];newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2];newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HueShift2 : "+ex)}} function HueShift3(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=Math.min(iplImage.RGBA[ji]*1.2,255);newIplImage.RGBA[ji+1]=Math.min(iplImage.RGBA[ji+1]*1.1,255);newIplImage.RGBA[ji+2]=iplImage.RGBA[ji+2]*0.7;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HueShift3 : "+ex)}} function Brighten(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var brightness=40;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=Math.min(255,iplImage.RGBA[ji]+brightness);newIplImage.RGBA[ji+1]=Math.min(255,iplImage.RGBA[ji+1]+brightness);newIplImage.RGBA[ji+2]=Math.min(255,iplImage.RGBA[ji+2]+brightness);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Brighten : "+ex)}} function Contrast(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var contrast=1.5;var midpoint=128;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;for(var c=0;c<3;c++){var value=iplImage.RGBA[ji+c];value=(value-midpoint)*contrast+midpoint;newIplImage.RGBA[ji+c]=Math.max(0,Math.min(255,value))} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Contrast : "+ex)}} function Posterize(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var levels=4;var step=256/levels;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;for(var c=0;c<3;c++){var value=iplImage.RGBA[ji+c];value=Math.floor(value/step)*step;newIplImage.RGBA[ji+c]=value} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Posterize : "+ex)}} function Pixelate(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var blockSize=8;for(var y=0;y<iplImage.height;y+=blockSize){for(var x=0;x<iplImage.width;x+=blockSize){var sumR=0,sumG=0,sumB=0,count=0;for(var dy=0;dy<blockSize&&y+dy<iplImage.height;dy++){for(var dx=0;dx<blockSize&&x+dx<iplImage.width;dx++){var ji=((x+dx)+(y+dy)*iplImage.width)*CHANNELS;sumR+=iplImage.RGBA[ji];sumG+=iplImage.RGBA[ji+1];sumB+=iplImage.RGBA[ji+2];count++}} var avgR=sumR/count,avgG=sumG/count,avgB=sumB/count;for(var dy=0;dy<blockSize&&y+dy<iplImage.height;dy++){for(var dx=0;dx<blockSize&&x+dx<iplImage.width;dx++){var ji=((x+dx)+(y+dy)*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=avgR;newIplImage.RGBA[ji+1]=avgG;newIplImage.RGBA[ji+2]=avgB;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Pixelate : "+ex)}} function AddNoise(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var noiseLevel=30;for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;for(var c=0;c<3;c++){var noise=Math.floor((Math.random()-0.5)*noiseLevel*2);var value=iplImage.RGBA[ji+c]+noise;newIplImage.RGBA[ji+c]=Math.max(0,Math.min(255,value))} newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("AddNoise : "+ex)}} function Mirror(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var srcJi=(j+i*iplImage.width)*CHANNELS;var dstJi=((iplImage.width-1-j)+i*iplImage.width)*CHANNELS;for(var c=0;c<4;c++){newIplImage.RGBA[dstJi+c]=iplImage.RGBA[srcJi+c]}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("Mirror : "+ex)}} function PrewittEdge(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var y=1;y<iplImage.height-1;y++){for(var x=1;x<iplImage.width-1;x++){var gx=0;var gy=0;var kernelX=[[-1,0,1],[-1,0,1],[-1,0,1]];var kernelY=[[-1,-1,-1],[0,0,0],[1,1,1]];for(var ky=-1;ky<=1;ky++){for(var kx=-1;kx<=1;kx++){var px=x+kx;var py=y+ky;var index=(px+py*iplImage.width)*CHANNELS;var r=iplImage.RGBA[index];var g=iplImage.RGBA[index+1];var b=iplImage.RGBA[index+2];var gray=(r+g+b)/3;var wx=kernelX[ky+1][kx+1];var wy=kernelY[ky+1][kx+1];gx+=gray*wx;gy+=gray*wy}} var magnitude=Math.sqrt(gx*gx+gy*gy);magnitude=Math.min(255,Math.max(0,magnitude));var outIdx=(x+y*iplImage.width)*CHANNELS;newIplImage.RGBA[outIdx]=magnitude;newIplImage.RGBA[outIdx+1]=magnitude;newIplImage.RGBA[outIdx+2]=magnitude;newIplImage.RGBA[outIdx+3]=255}} cvShowImage(imgId,newIplImage)}catch(ex){alert("PrewittEdge : "+ex)}} function FadedColor(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];var fade=0.6;var avg=(r+g+b)/3;newIplImage.RGBA[ji]=avg*fade+r*0.2;newIplImage.RGBA[ji+1]=avg*fade+g*0.2;newIplImage.RGBA[ji+2]=avg*fade+b*0.2;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("FadedColor : "+ex)}} function ScratchEffect(imgId,iplImage){try{var newIplImage=cvCloneImage(iplImage);for(var i=0;i<100;i++){var randX=Math.floor(Math.random()*iplImage.width);var randY=Math.floor(Math.random()*iplImage.height);var isVertical=Math.random()<0.5;if(isVertical){for(var y=0;y<iplImage.height;y++){var ji=(randX+y*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=newIplImage.RGBA[ji+1]=newIplImage.RGBA[ji+2]=220}}else{for(var x=0;x<iplImage.width;x++){var ji=(x+randY*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=newIplImage.RGBA[ji+1]=newIplImage.RGBA[ji+2]=220}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("ScratchEffect : "+ex)}} function ScratchEffect02(a,t){try{for(var r=cvCloneImage(t),o=t.width,h=t.height,c=0;c<200;c++)for(var f=Math.floor(Math.random()*o),e=Math.floor(Math.random()*h),n=0;n<300;n++){var M=f+n,m=e+n;0<=M&&M<o&&0<=m&&m<h&&(m=(M+m*o)*CHANNELS,r.RGBA[m]=r.RGBA[1+m]=r.RGBA[2+m]=300)}cvShowImage(a,r)}catch(a){alert("ScratchEffect02 : "+a)}}function ScratchEffect03(a,t){try{for(var r=cvCloneImage(t),o=t.width,h=t.height,c=0;c<1e3;c++)for(var f=Math.floor(Math.random()*o),e=Math.floor(Math.random()*h),n=0;n<30;n++){var M=f+Math.floor(9*Math.random()-4),m=e+Math.floor(9*Math.random()-4);0<=M&&M<o&&0<=m&&m<h&&(m=(M+m*o)*CHANNELS,r.RGBA[m]=255,r.RGBA[1+m]=255,r.RGBA[2+m]=255)}cvShowImage(a,r)}catch(a){alert("ScratchEffect03 : "+a)}}function ScratchEffect04(a,t){try{for(var r=cvCloneImage(t),o=t.width,h=t.height,c=0;c<10;c++)for(var f=20*Math.random()+10,e=.05*Math.random()+.01,n=Math.floor(Math.random()*h),M=0;M<o;M++){var m=Math.floor(n+f*Math.sin(e*M));0<=m&&m<h&&(m=(M+m*o)*CHANNELS,r.RGBA[m]=r.RGBA[1+m]=r.RGBA[2+m]=255)}cvShowImage(a,r)}catch(a){alert("ScratchEffect04 : "+a)}}function ScratchEffect05(a,t){try{for(var r=cvCloneImage(t),o=t.width,h=t.height,c=0;c<50;c++)for(var f=Math.floor(Math.random()*o),e=Math.floor(Math.random()*h),n=Math.floor(10*Math.random()+5),M=-n;M<=n;M++)for(var m,v,l=-n;l<=n;l++)l*l+M*M<=n*n&&(v=e+M,0<=(m=f+l)&&m<o&&0<=v&&v<h&&(v=(m+v*o)*CHANNELS,r.RGBA[v]=r.RGBA[1+v]=r.RGBA[2+v]=180));cvShowImage(a,r)}catch(a){alert("ScratchEffect06 : "+a)}} function AddFrame01(imgId,iplImage){try{var frameSize=15;var newIplImage=cvCloneImage(iplImage);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){if(i<frameSize||i>=iplImage.height-frameSize||j<frameSize||j>=iplImage.width-frameSize){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=139;newIplImage.RGBA[ji+1]=69;newIplImage.RGBA[ji+2]=19;newIplImage.RGBA[ji+3]=255}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("AddFrame01 : "+ex)}} function AddFrame02(imgId,iplImage){try{var frameSize=20;var newIplImage=cvCloneImage(iplImage);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){if(i<frameSize||i>=iplImage.height-frameSize||j<frameSize||j>=iplImage.width-frameSize){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=139;newIplImage.RGBA[ji+1]=69;newIplImage.RGBA[ji+2]=19;newIplImage.RGBA[ji+3]=255}}} cvShowImage(imgId,newIplImage)}catch(ex){alert("AddFrame02 : "+ex)}} function AddFrame03(a,h){try{for(var t=cvCloneImage(h),d=0;d<h.height;d++)for(var o,r,i=0;i<h.width;i++)(d<15||d>=h.height-15||i<15||i>=h.width-15)&&(o=(i+d*h.width)*CHANNELS,r=Math.floor(20*Math.random()),t.RGBA[o]=Math.min(255,166+r),t.RGBA[1+o]=Math.min(255,124+r),t.RGBA[2+o]=Math.min(255,82+r),t.RGBA[3+o]=255);cvShowImage(a,t)}catch(a){alert("AddFrame03 : "+a)}} function AddFrame04(a,h){try{for(var t=cvCloneImage(h),d=0;d<h.height;d++)for(var o,r,i=0;i<h.width;i++)(d<20||d>=h.height-15||i<15||i>=h.width-15)&&(o=(i+d*h.width)*CHANNELS,r=Math.floor(20*Math.random()),t.RGBA[o]=Math.min(255,166+r),t.RGBA[1+o]=Math.min(255,124+r),t.RGBA[2+o]=Math.min(255,82+r),t.RGBA[3+o]=255);cvShowImage(a,t)}catch(a){alert("AddFrame04 : "+a)}} function MonochromeInvert(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var avg=Math.floor((iplImage.RGBA[ji]+iplImage.RGBA[ji+1]+iplImage.RGBA[ji+2])/3);var inv=255-avg;newIplImage.RGBA[ji]=inv;newIplImage.RGBA[ji+1]=inv;newIplImage.RGBA[ji+2]=inv;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("MonochromeInvert : "+ex)}} function InfraredStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];newIplImage.RGBA[ji]=Math.min(255,r*1.2);newIplImage.RGBA[ji+1]=Math.min(255,255-g*0.5);newIplImage.RGBA[ji+2]=Math.min(255,255-b*0.5);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("InfraredStyle : "+ex)}} function CoolTone(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;newIplImage.RGBA[ji]=iplImage.RGBA[ji]*0.5;newIplImage.RGBA[ji+1]=iplImage.RGBA[ji+1]*0.7;newIplImage.RGBA[ji+2]=Math.min(iplImage.RGBA[ji+2]*1.4,255);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("CoolTone : "+ex)}}function HorrorStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji]*0.2;var g=iplImage.RGBA[ji+1]*1.2;var b=iplImage.RGBA[ji+2]*0.2;newIplImage.RGBA[ji]=Math.min(r,255);newIplImage.RGBA[ji+1]=Math.min(g,255);newIplImage.RGBA[ji+2]=Math.min(b,255);newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("HorrorStyle : "+ex)}} function HorrorRedStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=1.3*t.RGBA[e],A=.2*t.RGBA[1+e],B=.2*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorRedStyle : "+r)}}function HorrorBlueStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=.2*t.RGBA[e],A=.2*t.RGBA[1+e],B=1.5*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorBlueStyle : "+r)}}function HorrorYellowStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=1.2*t.RGBA[e],A=1.2*t.RGBA[1+e],B=.2*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorYellowStyle : "+r)}} function HorrorBloodStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=1.4*t.RGBA[e],A=.1*t.RGBA[1+e],B=.1*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorBloodStyle : "+r)}} function HorrorFogStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=.6*t.RGBA[e],A=.6*t.RGBA[1+e],B=.6*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorFogStyle : "+r)}}function HorrorVioletStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=.5*t.RGBA[e],A=.1*t.RGBA[1+e],B=1.3*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorVioletStyle : "+r)}}function HorrorMonoStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=128<(i=.3*t.RGBA[e]+.59*t.RGBA[1+e]+.11*t.RGBA[2+e])?255:0;a.RGBA[e]=a.RGBA[1+e]=a.RGBA[2+e]=i,a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorMonoStyle : "+r)}}function HorrorColdStyle(r,t){try{for(var a=cvCreateImage(t.width,t.height),h=0;h<t.height;h++)for(var o=0;o<t.width;o++){var e=(o+h*t.width)*CHANNELS,i=.5*t.RGBA[e],A=.8*t.RGBA[1+e],B=1.5*t.RGBA[2+e];a.RGBA[e]=Math.min(i,255),a.RGBA[1+e]=Math.min(A,255),a.RGBA[2+e]=Math.min(B,255),a.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(r,a)}catch(r){alert("HorrorColdStyle : "+r)}}function HorrorRedFrameStyle(a,t){try{var h=30;const m=cvCloneImage(t);for(let t=0;t<m.height;t++)for(let a=0;a<m.width;a++){var o,r=(a+t*m.width)*CHANNELS;t<h||t>=m.height-h||a<h||a>=m.width-h?(o=Math.floor(50*Math.random()),m.RGBA[r]=Math.min(255,200+o),m.RGBA[1+r]=Math.max(0,10-o),m.RGBA[2+r]=Math.max(0,10-o),m.RGBA[3+r]=255):t<40||t>=m.height-40||a<40||a>=m.width-40?(o=Math.min(Math.min(t-h,m.height-h-t-1),Math.min(a-h,m.width-h-a-1)),o=Math.max(0,255-30*o),m.RGBA[r]=Math.max(m.RGBA[r],100+80*Math.random()),m.RGBA[1+r]=Math.min(m.RGBA[1+r],10),m.RGBA[2+r]=Math.min(m.RGBA[2+r],10),m.RGBA[3+r]=Math.max(m.RGBA[3+r],o)):Math.random()<.005&&(m.RGBA[r]=180+Math.floor(50*Math.random()),m.RGBA[1+r]=Math.floor(30*Math.random()),m.RGBA[2+r]=Math.floor(30*Math.random()),m.RGBA[3+r]=255)}cvShowImage(a,m)}catch(a){alert("HorrorRedFrameStyle : "+a)}}function HorrorFadeStyle(r,t){try{for(var a=cvCloneImage(t),h=0;h<a.height;h++)for(var o=0;o<a.width;o++){var e=(o+h*a.width)*CHANNELS;a.RGBA[e]*=.5,a.RGBA[1+e]*=.5,a.RGBA[2+e]*=.5}cvShowImage(r,a)}catch(r){alert("HorrorFadeStyle : "+r)}}function HorrorFlickerStyle(r,t){try{for(var a=cvCloneImage(t),h=0;h<a.height;h++)for(var o=0;o<a.width;o++){var e,i=(o+h*a.width)*CHANNELS;Math.random()<.15&&(e=Math.floor(255*Math.random()),a.RGBA[i]=e,a.RGBA[1+i]=e,a.RGBA[2+i]=e)}cvShowImage(r,a)}catch(r){alert("HorrorFlickerStyle : "+r)}}function HorrorFlickerStyle02(r,t){try{for(var a=cvCloneImage(t),h=0;h<a.height;h++)for(var o=0;o<a.width;o++){var e,i=(o+h*a.width)*CHANNELS;Math.random()<.5&&(e=Math.floor(255*Math.random()),a.RGBA[i]=e,a.RGBA[1+i]=e,a.RGBA[2+i]=e)}cvShowImage(r,a)}catch(r){alert("HorrorFlickerStyle02 : "+r)}}function AnimeStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];r=r>200?255:r>128?192:r>64?96:0;g=g>200?255:g>128?192:g>64?96:0;b=b>200?255:b>128?192:b>64?96:0;newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("AnimeStyle : "+ex)}} function ToyCameraStyle(imgId,iplImage){try{var newIplImage=cvCreateImage(iplImage.width,iplImage.height);var centerX=iplImage.width/2;var centerY=iplImage.height/2;var maxDist=Math.sqrt(centerX*centerX+centerY*centerY);for(var i=0;i<iplImage.height;i++){for(var j=0;j<iplImage.width;j++){var ji=(j+i*iplImage.width)*CHANNELS;var r=iplImage.RGBA[ji];var g=iplImage.RGBA[ji+1];var b=iplImage.RGBA[ji+2];r=Math.min(255,r*1.3);g=Math.min(255,g*1.1);b=Math.min(255,b*1.3);var dx=j-centerX;var dy=i-centerY;var dist=Math.sqrt(dx*dx+dy*dy)/maxDist;var vignette=1-Math.pow(dist,2);r*=vignette;g*=vignette;b*=vignette;newIplImage.RGBA[ji]=r;newIplImage.RGBA[ji+1]=g;newIplImage.RGBA[ji+2]=b;newIplImage.RGBA[ji+3]=iplImage.RGBA[ji+3]}} cvShowImage(imgId,newIplImage)}catch(ex){alert("ToyCameraStyle : "+ex)}} function SnowClustersEffect01(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<20;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),f=Math.floor(40*Math.random()+30),e=.3*Math.random()+.7,i=Math.max(0,m-f);i<Math.min(o,m+f);i++)for(var c=Math.max(0,n-f);c<Math.min(r,n+f);c++){var l=(c+i*r)*CHANNELS,A=c-n,v=i-m,v=Math.sqrt(A*A+v*v);v<f&&(v=e*(1-v/f),h.RGBA[l]=Math.min(255,h.RGBA[l]+255*v),h.RGBA[1+l]=Math.min(255,h.RGBA[1+l]+255*v),h.RGBA[2+l]=Math.min(255,h.RGBA[2+l]+255*v))}cvShowImage(a,h)}catch(a){alert("SnowClustersEffect : "+a)}}function SnowClustersEffect02(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<40;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),f=Math.floor(40*Math.random()+30),e=.3*Math.random()+.7,i=Math.max(0,m-f);i<Math.min(o,m+f);i++)for(var c=Math.max(0,n-f);c<Math.min(r,n+f);c++){var l=(c+i*r)*CHANNELS,A=c-n,v=i-m,v=Math.sqrt(A*A+v*v);v<f&&(v=e*(1-v/f),h.RGBA[l]=Math.min(255,h.RGBA[l]+255*v),h.RGBA[1+l]=Math.min(255,h.RGBA[1+l]+255*v),h.RGBA[2+l]=Math.min(255,h.RGBA[2+l]+255*v))}cvShowImage(a,h)}catch(a){alert("SnowClustersEffect : "+a)}}function SnowClustersTiny(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<60;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(10*Math.random()+5),e=.5*Math.random()+.5,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+220*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+220*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+220*B))}cvShowImage(a,h)}catch(a){alert("SnowClustersTiny : "+a)}}function SnowClustersSoft(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<30;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(50*Math.random()+50),e=.2*Math.random()+.2,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*Math.pow(1-B/i,2),h.RGBA[f]=Math.min(255,h.RGBA[f]+200*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+200*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+200*B))}cvShowImage(a,h)}catch(a){alert("SnowClustersSoft : "+a)}}function SnowClustersCool(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<25;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(30*Math.random()+20),e=.4*Math.random()+.6,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+210*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+230*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+255*B))}cvShowImage(a,h)}catch(a){alert("SnowClustersCool : "+a)}}function SnowClustersStorm(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<70;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(25*Math.random()+10),e=.6*Math.random()+.7,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+255*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+255*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+255*B))}cvShowImage(a,h)}catch(a){alert("SnowClustersStorm : "+a)}} function PetalFlutter(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<50;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(10*Math.random()+6),e=.5*Math.random()+.5,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+255*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+120*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+200*B))}cvShowImage(a,h)}catch(a){alert("PetalFlutter : "+a)}} function PetalStorm(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<150;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(15*Math.random()+8),e=.8*Math.random()+.5,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+255*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+100*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+180*B))}cvShowImage(a,h)}catch(a){alert("PetalStorm : "+a)}} function FallingPetals(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<150;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o*.5),i=Math.floor(10*Math.random()+8),e=.6*Math.random()+.4,A=m;A<Math.min(o,m+2*i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n,B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+255*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+130*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+160*B))}cvShowImage(a,h)}catch(a){alert("FallingPetals : "+a)}} function PetalHaze(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<180;M++)for(var m=Math.floor(Math.random()*r),n=Math.floor(Math.random()*o),e=Math.floor(40*Math.random()+20),i=.2*Math.random()+.4,f=Math.max(0,n-e);f<Math.min(o,n+e);f++)for(var l=Math.max(0,m-e);l<Math.min(r,m+e);l++){var A=(l+f*r)*CHANNELS,v=l-m,B=f-n,B=Math.sqrt(v*v+B*B);B<e&&(B=i*(B=1-B/e)*B,h.RGBA[A]=Math.min(255,h.RGBA[A]+255*B),h.RGBA[1+A]=Math.min(255,h.RGBA[1+A]+180*B),h.RGBA[2+A]=Math.min(255,h.RGBA[2+A]+200*B))}cvShowImage(a,h)}catch(a){alert("PetalHaze : "+a)}} function CherryDrift(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<80;M++)for(var n=Math.floor(Math.random()*r),m=Math.floor(Math.random()*o),i=Math.floor(12*Math.random()+6),e=.5*Math.random()+.5,A=Math.max(0,m-i);A<Math.min(o,m+i);A++)for(var l=Math.max(0,n-i);l<Math.min(r,n+i);l++){var f=(l+A*r)*CHANNELS,G=l-n+.5*(A-m),B=A-m,B=Math.sqrt(G*G+B*B);B<i&&(B=e*(1-B/i),h.RGBA[f]=Math.min(255,h.RGBA[f]+255*B),h.RGBA[1+f]=Math.min(255,h.RGBA[1+f]+140*B),h.RGBA[2+f]=Math.min(255,h.RGBA[2+f]+180*B))}cvShowImage(a,h)}catch(a){alert("CherryDrift : "+a)}} function FireGlow(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<o;M++)for(var n=0;n<r;n++){var m=(n+M*r)*CHANNELS,i=t.RGBA[m],e=t.RGBA[1+m],A=t.RGBA[2+m],l=(i+e+A)/3/255;h.RGBA[m]=Math.min(255,i+120*l),h.RGBA[1+m]=Math.max(0,e-40),h.RGBA[2+m]=Math.max(0,A-80)}cvShowImage(a,h)}catch(a){alert("FireGlow : "+a)}}function FrozenBlue(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<o;M++)for(var n=0;n<r;n++){var m=(n+M*r)*CHANNELS,i=t.RGBA[m],e=t.RGBA[1+m],A=t.RGBA[2+m];h.RGBA[m]=Math.max(0,i-50),h.RGBA[1+m]=Math.min(255,e+20),h.RGBA[2+m]=Math.min(255,A+80)}cvShowImage(a,h)}catch(a){alert("FrozenBlue : "+a)}}function GoldenShine(a,t){try{for(var h=cvCloneImage(t),r=t.width,o=t.height,M=0;M<o;M++)for(var n=0;n<r;n++){var m=(n+M*r)*CHANNELS,i=(t.RGBA[m]+t.RGBA[1+m]+t.RGBA[2+m])/3;h.RGBA[m]=Math.min(255,60+i),h.RGBA[1+m]=Math.min(255,50+i),h.RGBA[2+m]=Math.max(0,i-20)}cvShowImage(a,h)}catch(a){alert("GoldenShine : "+a)}} function Star01(a,t){try{let h=cvCloneImage(t),o=t.width,r=t.height;for(let a=0;a<80;a++){var M=Math.floor(Math.random()*o),m=Math.floor(Math.random()*r),n=Math.floor(6+4*Math.random()),l=.7+.3*Math.random();for(let t=Math.max(0,m-n);t<Math.min(r,m+n);t++)for(let a=Math.max(0,M-n);a<Math.min(o,M+n);a++){var e=(a+t*o)*CHANNELS,f=a-M,i=t-m,i=Math.sqrt(f*f+i*i);i<n&&(i=l*(1-i/n),h.RGBA[e]=Math.min(255,h.RGBA[e]+255*i),h.RGBA[1+e]=Math.min(255,h.RGBA[1+e]+220*i),h.RGBA[2+e]=Math.min(255,h.RGBA[2+e]+60*i))}}cvShowImage(a,h)}catch(a){alert("Star01 : "+a)}}function Star02(a,t){try{let h=cvCloneImage(t),o=t.width,r=t.height;for(let a=0;a<200;a++){var M=Math.floor(Math.random()*o),m=Math.floor(Math.random()*r),n=Math.floor(6+4*Math.random()),l=1+.5*Math.random();for(let t=Math.max(0,m-n);t<Math.min(r,m+n);t++)for(let a=Math.max(0,M-n);a<Math.min(o,M+n);a++){var e=(a+t*o)*CHANNELS,f=a-M,i=t-m,i=Math.sqrt(f*f+i*i);i<n&&(i=l*(1-i/n),h.RGBA[e]=Math.min(255,h.RGBA[e]+255*i),h.RGBA[1+e]=Math.min(255,h.RGBA[1+e]+220*i),h.RGBA[2+e]=Math.min(255,h.RGBA[2+e]+100*i))}}cvShowImage(a,h)}catch(a){alert("Star02 : "+a)}}function Star03(a,t){try{let h=cvCloneImage(t),o=t.width,r=t.height;for(let a=0;a<250;a++){var M=Math.floor(Math.random()*o),m=Math.floor(Math.random()*r),n=Math.floor(6+5*Math.random()),l=.9+.6*Math.random(),e=Math.floor(180+75*Math.random()),f=Math.floor(100+155*Math.random()),i=Math.floor(180+75*Math.random());for(let t=Math.max(0,m-n);t<Math.min(r,m+n);t++)for(let a=Math.max(0,M-n);a<Math.min(o,M+n);a++){var A=(a+t*o)*CHANNELS,d=a-M,B=t-m,B=Math.sqrt(d*d+B*B);B<n&&(B=l*(1-B/n),h.RGBA[A]=Math.min(255,h.RGBA[A]+e*B),h.RGBA[1+A]=Math.min(255,h.RGBA[1+A]+f*B),h.RGBA[2+A]=Math.min(255,h.RGBA[2+A]+i*B))}}cvShowImage(a,h)}catch(a){alert("Star03 : "+a)}} function Hologram01(t,h){try{for(var a=cvCreateImage(h.width,h.height),o=0;o<a.height;o++)for(var r=0;r<a.width;r++){var e=1.5-Math.sqrt(Math.pow(o-a.height/2,2)+Math.pow(r-a.width/2,2))/Math.sqrt(Math.pow(a.width/2,2)+Math.pow(a.height/2,2)),g=(r+o)%180,i=(r+o*a.width)*CHANNELS;a.RGBA[i]=g,a.RGBA[1+i]=400*e,a.RGBA[2+i]=150*e,a.RGBA[3+i]=120*e}cvCvtColor(a,a,CV_CODE.HSV2RGB);var v=cvCloneImage(h);cvBlendImage(v,a,v,CV_BLEND_MODE.SCREEN),cvShowImage(t,v)}catch(t){alert("Hologram01 : "+t)}} function Hologram02(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=(e+h)%180,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=210,r.RGBA[2+v]=200,r.RGBA[3+v]=120}cvCvtColor(r,r,CV_CODE.HSV2RGB);var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("Hologram02 : "+a)}} function Hologram03(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=(e+h)%180,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=180,r.RGBA[2+v]=180,r.RGBA[3+v]=150}cvCvtColor(r,r,CV_CODE.HSV2RGB);var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("Hologram03 : "+a)}} function Hologram04(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=(e+h)%180,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=150,r.RGBA[2+v]=150,r.RGBA[3+v]=100}cvCvtColor(r,r,CV_CODE.HSV2RGB);var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("Hologram04 : "+a)}} function Hologram05(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=1-Math.sqrt(Math.pow(h-r.height/2,2)+Math.pow(e-r.width/2,2))/Math.sqrt(Math.pow(r.width/2,2)+Math.pow(r.height/2,2)),v=(e+h)%180,c=(e+h*r.width)*CHANNELS;r.RGBA[c]=v,r.RGBA[1+c]=400*o,r.RGBA[2+c]=150*o,r.RGBA[3+c]=120*o}cvCvtColor(r,r,CV_CODE.HSV2RGB);var g=cvCloneImage(t);cvBlendImage(g,r,g,CV_BLEND_MODE.SCREEN),cvShowImage(a,g)}catch(a){alert("Hologram05 : "+a)}} function MagicDust01(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=.94<Math.random()?255:0,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=o,r.RGBA[2+v]=o,r.RGBA[3+v]=255}var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("MagicDust01 : "+a)}}function MagicDust02(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=.88<Math.random()?255:0,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=o,r.RGBA[2+v]=o,r.RGBA[3+v]=255}var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("MagicDust02 : "+a)}}function MagicDust03(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=.78<Math.random()?255:0,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=o,r.RGBA[2+v]=o,r.RGBA[3+v]=255}var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("MagicDust03 : "+a)}}function MagicDust04(a,t){try{for(var r=cvCreateImage(t.width,t.height),h=0;h<r.height;h++)for(var e=0;e<r.width;e++){var o=.68<Math.random()?255:0,v=(e+h*r.width)*CHANNELS;r.RGBA[v]=o,r.RGBA[1+v]=o,r.RGBA[2+v]=o,r.RGBA[3+v]=255}var c=cvCloneImage(t);cvBlendImage(c,r,c,CV_BLEND_MODE.SCREEN),cvShowImage(a,c)}catch(a){alert("MagicDust04 : "+a)}} function FadedSun(a,t){try{for(var e=cvCloneImage(t),n=0;n<e.RGBA.length;n+=4)e.RGBA[n]=Math.min(e.RGBA[n]+30,255),e.RGBA[n+1]=Math.max(e.RGBA[n+1]-20,0),e.RGBA[n+2]=Math.max(e.RGBA[n+2]-30,0);cvShowImage(a,e)}catch(a){alert("FadedSun : "+a)}}function OldFilm(a,t){try{for(var l=cvCloneImage(t),m=0;m<l.RGBA.length;m+=4){var n=.3*l.RGBA[m]+.59*l.RGBA[m+1]+.11*l.RGBA[m+2];l.RGBA[m]=Math.min(40+n,255),l.RGBA[m+1]=Math.min(20+n,255),l.RGBA[m+2]=Math.min(n,255)}cvShowImage(a,l)}catch(a){alert("OldFilm : "+a)}}function ToyCameraStyle02(a,t){try{for(var h=cvCreateImage(t.width,t.height),A=t.width/2,r=t.height/2,e=Math.sqrt(A*A+r*r),G=0;G<t.height;G++)for(var B=0;B<t.width;B++){var R=(B+G*t.width)*CHANNELS,o=1.4*t.RGBA[R],i=+t.RGBA[1+R],m=.9*t.RGBA[2+R],n=B-A,v=G-r,v=Math.sqrt(n*n+v*v)/e,v=1-Math.pow(v,3),o=Math.min(255,o*v),i=Math.min(255,i*v),m=Math.min(255,m*v);h.RGBA[R]=o,h.RGBA[1+R]=i,h.RGBA[2+R]=m,h.RGBA[3+R]=t.RGBA[3+R]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle02 : "+a)}}function ToyCameraStyle03(a,t){try{var h=cvCloneImage(t);cvSmooth(h,h,CV_SMOOTH_TYPE.GAUSSIAN,5);for(var A=cvCreateImage(t.width,t.height),r=t.width/2,e=t.height/2,G=Math.sqrt(r*r+e*e),B=0;B<t.height;B++)for(var R=0;R<t.width;R++){var o=(R+B*t.width)*CHANNELS,i=.9*h.RGBA[o],m=+h.RGBA[1+o],n=1.3*h.RGBA[2+o],v=R-r,c=B-e,c=Math.sqrt(v*v+c*c)/G,c=1-Math.pow(c,2.5),i=Math.min(255,i*c),m=Math.min(255,m*c),n=Math.min(255,n*c);A.RGBA[o]=i,A.RGBA[1+o]=m,A.RGBA[2+o]=n,A.RGBA[3+o]=t.RGBA[3+o]}cvShowImage(a,A)}catch(a){alert("ToyCameraStyle03 : "+a)}}function ToyCameraStyle04(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=.3*(B=t.RGBA[e])+.59*(R=t.RGBA[1+e])+.11*(o=t.RGBA[2+e]),B=G+.5*(B-G)+20,R=G+.5*(R-G)+20,o=G+.5*(o-G)+20;h.RGBA[e]=Math.min(255,B),h.RGBA[1+e]=Math.min(255,R),h.RGBA[2+e]=Math.min(255,o),h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle04 : "+a)}}function ToyCameraStyle05(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=t.RGBA[e],B=t.RGBA[1+e],R=t.RGBA[2+e],G=Math.min(255,255*Math.pow(G/255,.8)),B=Math.min(255,255*Math.pow(B/255,1.2)),R=Math.min(255,255*Math.pow(R/255,1.1)+10);h.RGBA[e]=G,h.RGBA[1+e]=B,h.RGBA[2+e]=R,h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle05 : "+a)}}function ToyCameraStyle06(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=(Math.min(r+2,t.width-1)+A*t.width)*CHANNELS,B=(Math.max(r-2,0)+A*t.width)*CHANNELS,R=t.RGBA[G],G=t.RGBA[1+e],B=t.RGBA[2+B];h.RGBA[e]=R,h.RGBA[1+e]=G,h.RGBA[2+e]=B,h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle06 : "+a)}}function ToyCameraStyle07(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=t.RGBA[e]+20,B=t.RGBA[1+e]+25,R=t.RGBA[2+e],G=255-.9*(255-G),B=255-.9*(255-B),R=255-.9*(255-R);h.RGBA[e]=Math.min(255,G),h.RGBA[1+e]=Math.min(255,B),h.RGBA[2+e]=Math.min(255,R),h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle07 : "+a)}}function ToyCameraStyle08(a,t){try{for(var h=cvCloneImage(t),A=t.width/2,r=t.height/2,e=Math.sqrt(A*A+r*r),G=0;G<t.height;G++)for(var B=0;B<t.width;B++){var R=(B+G*t.width)*CHANNELS,o=1.15*t.RGBA[R],i=1.2*t.RGBA[1+R],m=.95*t.RGBA[2+R],n=B-A,v=G-r,v=1-.3*(Math.sqrt(n*n+v*v)/e);o*=v,i*=v,m*=v,h.RGBA[R]=Math.min(255,o),h.RGBA[1+R]=Math.min(255,i),h.RGBA[2+R]=Math.min(255,m),h.RGBA[3+R]=t.RGBA[3+R]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle08 : "+a)}}function ToyCameraStyle09(a,t){try{for(var h=cvCloneImage(t),A=1;A<t.height-1;A++)for(var r=1;r<t.width-1;r++){var e=(r+A*t.width)*CHANNELS,G=(t.RGBA[e]+t.RGBA[1+e]+t.RGBA[2+e])/3,B=(t.RGBA[e+CHANNELS]+t.RGBA[e+CHANNELS+1]+t.RGBA[e+CHANNELS+2])/3,R=(t.RGBA[e+t.width*CHANNELS]+t.RGBA[e+t.width*CHANNELS+1]+t.RGBA[e+t.width*CHANNELS+2])/3,o=Math.abs(G-B)+Math.abs(G-R),B=1.1*t.RGBA[e],G=1.1*t.RGBA[1+e],R=1.1*t.RGBA[2+e],o=Math.exp(-o/40);B*=o,G*=o,R*=o,h.RGBA[e]=Math.min(255,B),h.RGBA[1+e]=Math.min(255,G),h.RGBA[2+e]=Math.min(255,R),h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle09 : "+a)}}function ToyCameraStyle10(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=1.5*((G=.3*t.RGBA[e]+.59*t.RGBA[1+e]+.11*t.RGBA[2+e])-128)+128,B=Math.min(255,20+G),R=Math.min(255,10+G),G=Math.min(255,G-10);h.RGBA[e]=B,h.RGBA[1+e]=R,h.RGBA[2+e]=G,h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle10 : "+a)}}function ToyCameraStyle11(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=64*Math.floor(t.RGBA[e]/64),B=64*Math.floor(t.RGBA[1+e]/64),R=64*Math.floor(t.RGBA[2+e]/64);h.RGBA[e]=G,h.RGBA[1+e]=B,h.RGBA[2+e]=R,h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle11 : "+a)}}function ToyCameraStyle12(a,t){try{for(var h=cvCloneImage(t),A=0;A<t.height;A++)for(var r=0;r<t.width;r++){var e=(r+A*t.width)*CHANNELS,G=1.3*((G=.3*t.RGBA[e]+.59*t.RGBA[1+e]+.11*t.RGBA[2+e])-128)+128;G=Math.max(0,Math.min(255,G)),h.RGBA[e]=G,h.RGBA[1+e]=G,h.RGBA[2+e]=G,h.RGBA[3+e]=t.RGBA[3+e]}cvShowImage(a,h)}catch(a){alert("ToyCameraStyle12 : "+a)}}function DigitalScanline01(t,a){try{var h=cvCloneImage(a);for(let a=0;a<h.height;a++)if(a%4==0)for(let t=0;t<h.width;t++){var o=4*(t+a*h.width);h.RGBA[o]=0,h.RGBA[1+o]=0,h.RGBA[2+o]=0}cvShowImage(t,h)}catch(t){alert("DigitalScanline01 : "+t)}}function DigitalScanline02(t,a){try{var h=cvCloneImage(a);for(let a=0;a<h.height;a++)if(a%8==0)for(let t=0;t<h.width;t++){var o=4*(t+a*h.width);h.RGBA[o]=0,h.RGBA[1+o]=0,h.RGBA[2+o]=0}cvShowImage(t,h)}catch(t){alert("DigitalScanline02 : "+t)}}function DigitalScanline03(t,a){try{var h=cvCloneImage(a);for(let a=0;a<h.height;a++)if(a%15==0)for(let t=0;t<h.width;t++){var o=4*(t+a*h.width);h.RGBA[o]=0,h.RGBA[1+o]=0,h.RGBA[2+o]=0}cvShowImage(t,h)}catch(t){alert("DigitalScanline03 : "+t)}}function DigitalScanline04(t,a){try{var h=cvCloneImage(a);for(let a=0;a<h.height;a++)if(a%30==0)for(let t=0;t<h.width;t++){var o=4*(t+a*h.width);h.RGBA[o]=0,h.RGBA[1+o]=0,h.RGBA[2+o]=0}cvShowImage(t,h)}catch(t){alert("DigitalScanline04 : "+t)}}function TVNoise(t,a){try{var h=cvCloneImage(a);for(let t=0;t<h.RGBA.length;t+=4){var o=80*(Math.random()-.5);h.RGBA[t]=Math.min(255,Math.max(0,h.RGBA[t]+o)),h.RGBA[t+1]=Math.min(255,Math.max(0,h.RGBA[t+1]+o)),h.RGBA[t+2]=Math.min(255,Math.max(0,h.RGBA[t+2]+o))}cvShowImage(t,h)}catch(t){alert("TVNoise : "+t)}}function PixelGlitch2(t,o){try{var e=cvCloneImage(o);for(let t=0;t<e.width;t+=10){var r=Math.floor(Math.random()*e.height/4);for(let h=0;h<e.height-r;h++)for(let a=t;a<t+10&&a<e.width;a++)for(let t=0;t<4;t++)e.RGBA[4*(a+h*e.width)+t]=o.RGBA[4*(a+(h+r)*e.width)+t]}cvShowImage(t,e)}catch(t){alert("PixelGlitch2 : "+t)}}function WaveDistort(t,h){try{const l=cvCloneImage(h);for(let a=0;a<l.height;a++)for(let t=0;t<l.width;t++){var o=Math.floor(5*Math.sin(2*Math.PI*a*.05)),o=Math.min(l.width-1,Math.max(0,t+o)),e=4*(t+a*l.width),r=4*(o+a*l.width);for(let t=0;t<4;t++)l.RGBA[e+t]=h.RGBA[r+t]}cvShowImage(t,l)}catch(t){alert("WaveDistort : "+t)}}function Twirl(t,h){try{const R=cvCloneImage(h);var o=R.width/2,e=R.height/2,r=Math.min(o,e);for(let a=0;a<R.height;a++)for(let t=0;t<R.width;t++){var l=t-o,n=a-e,i=Math.sqrt(l*l+n*n),n=Math.atan2(n,l)+i/r*3,l=Math.floor(o+i*Math.cos(n)),n=Math.floor(e+i*Math.sin(n)),c=4*(t+a*R.width),B=4*(Math.min(R.width-1,Math.max(0,l))+Math.min(R.height-1,Math.max(0,n))*R.width);for(let t=0;t<4;t++)R.RGBA[c+t]=h.RGBA[B+t]}cvShowImage(t,R)}catch(t){alert("Twirl : "+t)}}function Kaleidoscope01(t,h){try{const B=cvCloneImage(h);var o=B.width/2,e=B.height/2;for(let a=0;a<B.height;a++)for(let t=0;t<B.width;t++){var r=t-o,l=a-e,n=Math.atan2(l,r),r=Math.sqrt(r*r+l*l),n=(n+Math.PI)%(Math.PI/3),l=Math.floor(o+r*Math.cos(n)),n=Math.floor(e+r*Math.sin(n)),i=4*(t+a*B.width),c=4*(Math.min(B.width-1,Math.max(0,l))+Math.min(B.height-1,Math.max(0,n))*B.width);for(let t=0;t<4;t++)B.RGBA[i+t]=h.RGBA[c+t]}cvShowImage(t,B)}catch(t){alert("Kaleidoscope01 : "+t)}}function Kaleidoscope02(t,a){try{for(var h=cvCloneImage(a),o=h.width,e=h.height,r=0;r<e;r++)for(var l=0;l<o;l++){var n=Math.atan2(r-e/2,l-o/2),i=Math.sqrt(Math.pow(l-o/2,2)+Math.pow(r-e/2,2)),n=Math.floor((n+Math.PI)/(Math.PI/3))%6%2==0?n:-n,c=Math.floor(o/2+i*Math.cos(n)),B=Math.floor(e/2+i*Math.sin(n)),c=Math.max(0,Math.min(o-1,c)),B=Math.max(0,Math.min(e-1,B));for(let t=0;t<4;t++)h.RGBA[4*(l+r*o)+t]=a.RGBA[4*(c+B*o)+t]}cvShowImage(t,h)}catch(t){alert("Kaleidoscope02 : "+t)}}function Ripple01(t,h){try{const n=cvCloneImage(h);for(let a=0;a<n.height;a++){var o=Math.floor(5*Math.sin(.15*a));for(let t=0;t<n.width;t++){var e=Math.min(n.width-1,Math.max(0,t+o)),r=4*(t+a*n.width),l=4*(e+a*n.width);for(let t=0;t<4;t++)n.RGBA[r+t]=h.RGBA[l+t]}}cvShowImage(t,n)}catch(t){alert("Ripple01 : "+t)}}function Ripple02(t,o){try{var e=cvCloneImage(o);for(let h=0;h<e.height;h++)for(let a=0;a<e.width;a++){var r=5*Math.sin(2*Math.PI*h/30),l=5*Math.cos(2*Math.PI*a/30),n=Math.min(Math.max(a+r,0),e.width-1),i=Math.min(Math.max(h+l,0),e.height-1);for(let t=0;t<4;t++)e.RGBA[4*(a+h*e.width)+t]=o.RGBA[4*(Math.floor(n)+Math.floor(i)*e.width)+t]}cvShowImage(t,e)}catch(t){alert("Ripple02 : "+t)}}function CircleZoom(t,e){try{const A=cvCloneImage(e);var r=A.width/2,l=A.height/2,n=Math.min(r,l)/1.2;for(let o=0;o<A.height;o++)for(let h=0;h<A.width;h++){var i=h-r,c=o-l,B=Math.sqrt(i*i+c*c);let t=h,a=o;B<n&&(t=r+i/1.5,a=l+c/1.5);var R=4*(h+o*A.width),G=4*(Math.min(A.width-1,Math.max(0,Math.floor(t)))+Math.min(A.height-1,Math.max(0,Math.floor(a)))*A.width);for(let t=0;t<4;t++)A.RGBA[R+t]=e.RGBA[G+t]}cvShowImage(t,A)}catch(t){alert("CircleZoom : "+t)}}function FoldCorner01(t,h){try{const n=cvCloneImage(h);for(let a=0;a<60;a++)for(let t=0;t<60;t++){var o=60-t+a,e=60-a+t;if(o<h.width&&e<h.height){var r=4*(t+a*n.width),l=4*(o+e*n.width);for(let t=0;t<4;t++)n.RGBA[r+t]=.8*h.RGBA[l+t]}}cvShowImage(t,n)}catch(t){alert("FoldCorner01 : "+t)}}function FoldCorner02(t,h){try{const M=cvCloneImage(h);var o=M.width,e=M.height;for(let a=0;a<60;a++)for(let t=0;t<60;t++){var r=60-t+a,l=60-a+t;if(r<o&&l<e){var n=4*(t+a*o),i=4*(r+l*o);for(let t=0;t<3;t++)M.RGBA[n+t]=.7*h.RGBA[i+t]+50;M.RGBA[3+n]=255}}for(let a=e-60;a<e;a++)for(let t=o-60;t<o;t++){var c=t-(o-60),B=a-(e-60),R=o-1-(60-c+B),c=e-1-(60-B+c);if(0<=R&&0<=c){var G=4*(t+a*o),A=4*(R+c*o);for(let t=0;t<3;t++)M.RGBA[G+t]=.7*h.RGBA[A+t]+30;M.RGBA[3+G]=255}}cvShowImage(t,M)}catch(t){alert("FoldCorner02 : "+t)}}function FoldCorner03(t,h){try{const A=cvCloneImage(h);var o=A.width,e=A.height;for(let a=0;a<60;a++)for(let t=o-60;t<o;t++){var r=t-(o-60),l=o-1-(60-r+a),r=60-a+r;if(0<=l&&r<e){var n=4*(t+a*o),i=4*(l+r*o);for(let t=0;t<3;t++)A.RGBA[n+t]=.6*h.RGBA[i+t]+40;A.RGBA[3+n]=255}}for(let a=e-60;a<e;a++)for(let t=0;t<60;t++){var c=a-(e-60),B=60-t+c,c=e-1-(60-c+t);if(B<o&&0<=c){var R=4*(t+a*o),G=4*(B+c*o);for(let t=0;t<3;t++)A.RGBA[R+t]=.6*h.RGBA[G+t]+40;A.RGBA[3+R]=255}}cvShowImage(t,A)}catch(t){alert("FoldCorner03 : "+t)}}function FoldCorner04(t,r){try{const i=cvCloneImage(r);const c=i.width;var l=i.height;function n(t,a,h){var o=4*(t+a*c);for(let t=0;t<13;t++){var e=r.RGBA[o+t];i.RGBA[o+t]=h?Math.min(e+200,255):.5*e}i.RGBA[3+o]=255}function a(h,o){for(let a=0;a<60;a++)for(let t=0;t<60;t++){var e=h+t,r=o+a;0<=e&&e<c&&0<=r&&r<l&&(5<t&&5<a&&t<55&&a<55?n(e,r,!0):n(e,r,!1))}}a(0,0),a(c-60,0),a(0,l-60),a(c-60,l-60),cvShowImage(t,i)}catch(t){alert("FoldCorner04 : "+t)}}function VHSLines(t,a){try{const o=cvCloneImage(a);for(let a=0;a<o.height;a++)if(a%3==0)for(let t=0;t<o.width;t++){var h=4*(t+a*o.width);for(let t=0;t<3;t++)o.RGBA[h+t]=.5*o.RGBA[h+t]}cvShowImage(t,o)}catch(t){alert("VHSLines : "+t)}}function MetalEtching01(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t+(a-1)*n.width),r=4*(t-1+a*n.width);for(let t=0;t<3;t++){var l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t];n.RGBA[o+t]=Math.max(0,Math.min(255,128+l))}n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching01 : "+t)}}function MetalEtching02(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t-1+(a-1)*n.width),r=4*(t+1+(a+1)*n.width);for(let t=0;t<3;t++){var l=140+1.2*(l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t]);n.RGBA[o+t]=Math.max(0,Math.min(255,l))}n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching02 : "+t)}}function MetalEtching03(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t+(a-1)*n.width),r=4*(t-1+a*n.width),l=(h.RGBA[o]+h.RGBA[1+o]+h.RGBA[2+o])/3,e=(h.RGBA[e]+h.RGBA[1+e]+h.RGBA[2+e])/3,r=(h.RGBA[r]+h.RGBA[1+r]+h.RGBA[2+r])/3,r=Math.max(0,Math.min(255,l-e+128+(l-r)));n.RGBA[o]=n.RGBA[1+o]=n.RGBA[2+o]=r,n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching03 : "+t)}}function MetalEtching04(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t+1+(a-1)*n.width),r=4*(t-1+(a+1)*n.width);for(let t=0;t<3;t++){var l=128+1.2*(l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t]);n.RGBA[o+t]=Math.max(0,Math.min(255,l))}n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching04 : "+t)}}function MetalEtching05(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t+(a-1)*n.width),r=4*(t-1+a*n.width);for(let t=0;t<3;t++){var l=128+(l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t]);n.RGBA[o+t]=Math.max(0,Math.min(255,l))}n.RGBA[0+o]=Math.min(n.RGBA[0+o]+20,255),n.RGBA[2+o]=Math.min(n.RGBA[2+o]+40,255),n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching05 : "+t)}}function MetalEtching06(t,h){try{const n=cvCloneImage(h);for(let a=1;a<n.height-1;a++)for(let t=1;t<n.width-1;t++){var o=4*(t+a*n.width),e=4*(t+(a-1)*n.width),r=4*(t-1+a*n.width);for(let t=0;t<3;t++){var l=128+(l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t]);n.RGBA[o+t]=Math.max(0,Math.min(255,l))}n.RGBA[0+o]=Math.min(n.RGBA[0+o]+40,255),n.RGBA[1+o]=Math.min(n.RGBA[1+o]+40,255),n.RGBA[2+o]=Math.max(n.RGBA[2+o]-30,0),n.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,n)}catch(t){alert("MetalEtching06 : "+t)}}function MetalEtching07(t,h){try{const R=cvCloneImage(h);for(let a=1;a<R.height-1;a++)for(let t=1;t<R.width-1;t++){var o=4*(t+a*R.width),e=4*(t+(a-1)*R.width),r=4*(t-1+a*R.width);for(let t=0;t<3;t++){var l=128+(l=h.RGBA[o+t]-h.RGBA[e+t]+h.RGBA[o+t]-h.RGBA[r+t]);R.RGBA[o+t]=Math.max(0,Math.min(255,l))}var n=.299*(i=Math.min(R.RGBA[0+o]+40,255))+.587*(c=Math.min(R.RGBA[1+o]+40,255))+.114*(B=Math.max(R.RGBA[2+o]-30,0)),n=180<n?40:n<80?-20:0,i=Math.min(Math.max(i+n,0),255),c=Math.min(Math.max(c+n,0),255),B=Math.min(Math.max(B+n,0),255);R.RGBA[0+o]=i,R.RGBA[1+o]=c,R.RGBA[2+o]=B,R.RGBA[3+o]=h.RGBA[3+o]}cvShowImage(t,R)}catch(t){alert("MetalEtching07 : "+t)}}function MetalEtching08_NormalMap(t,h){try{const B=cvCloneImage(h);var o=B.width,e=B.height;for(let a=1;a<e-1;a++)for(let t=1;t<o-1;t++){var r=4*(t+a*o),l=-1*h.RGBA[4*(t-1+(a-1)*o)]+ +h.RGBA[4*(t+1+(a-1)*o)]+-2*h.RGBA[4*(t-1+a*o)]+2*h.RGBA[4*(t+1+a*o)]+-1*h.RGBA[4*(t-1+(a+1)*o)]+ +h.RGBA[4*(t+1+(a+1)*o)],n=-1*h.RGBA[4*(t-1+(a-1)*o)]+-2*h.RGBA[4*(t+(a-1)*o)]+-1*h.RGBA[4*(t+1+(a-1)*o)]+ +h.RGBA[4*(t-1+(a+1)*o)]+2*h.RGBA[4*(t+(a+1)*o)]+ +h.RGBA[4*(t+1+(a+1)*o)],i=l/255,c=n/255,n=Math.sqrt(i*i+c*c+1),i=i/n*.5+.5,c=c/n*.5+.5,l=1/n*.5+.5;B.RGBA[0+r]=Math.floor(255*i),B.RGBA[1+r]=Math.floor(255*c),B.RGBA[2+r]=Math.floor(255*l),B.RGBA[3+r]=255}cvShowImage(t,B)}catch(t){alert("MetalEtching08_NormalMap : "+t)}}function MetalEtching09_EnvironmentMap(t,h){try{const B=cvCloneImage(h);var o=B.width,e=B.height;for(let a=0;a<e;a++)for(let t=0;t<o;t++){var r=4*(t+a*o),l=.299*h.RGBA[0+r]+.587*h.RGBA[1+r]+.114*h.RGBA[2+r],n=200+40*Math.sin(.05*(t+a)),i=180+30*Math.sin(.05*(t-a)),c=100+20*Math.cos(.03*(t+a)),l=l/255;B.RGBA[0+r]=Math.min((1-l)*h.RGBA[0+r]+l*n,255),B.RGBA[1+r]=Math.min((1-l)*h.RGBA[1+r]+l*i,255),B.RGBA[2+r]=Math.min((1-l)*h.RGBA[2+r]+l*c,255),B.RGBA[3+r]=255}cvShowImage(t,B)}catch(t){alert("MetalEtching09_EnvironmentMap : "+t)}}function MetalEtching10_NormalEnvMix(t,h){try{const f=cvCloneImage(h);var o=f.width,e=f.height;for(let a=1;a<e-1;a++)for(let t=1;t<o-1;t++){var r,l=4*(t+a*o),n=-1*h.RGBA[4*(t-1+(a-1)*o)]+ +h.RGBA[4*(t+1+(a-1)*o)]+-2*h.RGBA[4*(t-1+a*o)]+2*h.RGBA[4*(t+1+a*o)]+-1*h.RGBA[4*(t-1+(a+1)*o)]+ +h.RGBA[4*(t+1+(a+1)*o)],i=-1*h.RGBA[4*(t-1+(a-1)*o)]+-2*h.RGBA[4*(t+(a-1)*o)]+-1*h.RGBA[4*(t+1+(a-1)*o)]+ +h.RGBA[4*(t-1+(a+1)*o)]+2*h.RGBA[4*(t+(a+1)*o)]+ +h.RGBA[4*(t+1+(a+1)*o)],c=n/255,B=i/255,R=Math.sqrt(c*c+B*B+1);c/=R,B/=R,r=1/R;var G=180+40*Math.sin(.04*(t+a)),A=160+30*Math.cos(.05*(t-a)),M=90+25*Math.sin(.03*(t+a)),n=Math.sqrt(1.29),i=.2/n,R=.5/n,n=1/n,n=Math.max(0,c*i+B*R+r*n);f.RGBA[0+l]=Math.min(G*n,255),f.RGBA[1+l]=Math.min(A*n,255),f.RGBA[2+l]=Math.min(M*n,255),f.RGBA[3+l]=255}cvShowImage(t,f)}catch(t){alert("MetalEtching10_NormalEnvMix : "+t)}}function MetalEtching11_DynamicLight(t,h){try{const f=cvCloneImage(h);var o=f.width,e=f.height,a=.001*Date.now(),r=Math.cos(a),l=Math.sin(a),a=Math.sqrt(r*r+l*l+1),n=r/a,i=l/a,c=1/a;for(let a=1;a<e-1;a++)for(let t=1;t<o-1;t++){var B=4*(t+a*o),R=-1*h.RGBA[4*(t-1+a*o)]+ +h.RGBA[4*(t+1+a*o)],G=-1*h.RGBA[4*(t+(a-1)*o)]+ +h.RGBA[4*(t+(a+1)*o)],A=R/255,M=G/255,R=1,G=Math.sqrt(A*A+M*M+1);A/=G,M/=G,R/=G;R=Math.max(0,A*n+M*i+R*c);f.RGBA[0+B]=Math.min(220*R,255),f.RGBA[1+B]=Math.min(190*R,255),f.RGBA[2+B]=Math.min(90*R,255),f.RGBA[3+B]=255}cvShowImage(t,f)}catch(t){alert("MetalEtching11_DynamicLight : "+t)}}function DeepGreen(t,a){try{const h=cvCloneImage(a);for(let t=0;t<h.RGBA.length;t+=4)h.RGBA[t]*=.8,h.RGBA[t+1]=Math.min(255,1.3*h.RGBA[t+1]),h.RGBA[t+2]*=.8;cvShowImage(t,h)}catch(t){alert("DeepGreen : "+t)}}function MonotoneBrown(t,a){try{const o=cvCloneImage(a);for(let t=0;t<o.RGBA.length;t+=4){var h=(o.RGBA[t]+o.RGBA[t+1]+o.RGBA[t+2])/3;o.RGBA[t]=Math.min(255,1.1*h),o.RGBA[t+1]=.9*h,o.RGBA[t+2]=.7*h}cvShowImage(t,o)}catch(t){alert("MonotoneBrown : "+t)}}function NeonGlow02(t,a){try{var h=cvCloneImage(a);cvCanny(h,h,100,200);for(let t=0;t<h.RGBA.length;t+=4)h.RGBA[t]=255,h.RGBA[t+1]=0,h.RGBA[t+2]=255,h.RGBA[t+3]=255;var o=cvCloneImage(a);cvBlendImage(o,h,o,CV_BLEND_MODE.SCREEN),cvShowImage(t,o)}catch(t){alert("NeonGlow02 : "+t)}}function LensRing(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height,e=h/2,r=o/2,l=Math.sqrt(e*e+r*r);for(let a=0;a<o;a++)for(let t=0;t<h;t++){var n=t-e,i=a-r,n=Math.sqrt(n*n+i*i),i=4*(a*h+t);.4*l<n&&n<.6*l&&(c.RGBA[i]=Math.min(255,c.RGBA[i]+50),c.RGBA[1+i]=Math.min(255,c.RGBA[1+i]+50),c.RGBA[2+i]=Math.min(255,c.RGBA[2+i]+100))}cvShowImage(t,c)}catch(t){alert("LensRing : "+t)}}function PrismFlash(t,a){try{var h=cvCloneImage(a),o=h.width,e=h.height;const n=h.RGBA;for(let a=0;a<e;a++)for(let t=0;t<o-5;t++){var r=4*(a*o+t),l=4*(a*o+(t+5));n[r]=h.RGBA[l],n[1+r]=h.RGBA[1+r],n[2+r]=h.RGBA[r-20+2]}cvShowImage(t,h)}catch(t){alert("PrismFlash : "+t)}}function LensReflection(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height,e=h/3,r=o/3,l=Math.min(h,o)/4;for(let a=0;a<o;a++)for(let t=0;t<h;t++){var n=t-e,i=a-r,n=Math.sqrt(n*n+i*i);n<l&&(i=300*(1-n/l),n=4*(a*h+t),c.RGBA[n]=Math.min(255,c.RGBA[n]+i),c.RGBA[1+n]=Math.min(255,c.RGBA[1+n]+i),c.RGBA[2+n]=Math.min(255,c.RGBA[2+n]+1.5*i))}cvShowImage(t,c)}catch(t){alert("LensReflection : "+t)}}function BubbleFloat01(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<30;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*(o/2)),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat01 : "+t)}}function BubbleFloat02(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<80;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*(o/2)),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat02 : "+t)}}function BubbleFloat03(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<130;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*(o/2)),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat03 : "+t)}}function BubbleFloat04(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<280;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*(o/2)),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat04 : "+t)}}function BubbleFloat05(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<400;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*(o/2)),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat05 : "+t)}}function BubbleFloat06(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<400;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*+o),i=3+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat06 : "+t)}}function BubbleFloat07(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<400;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*+o),i=5+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat07 : "+t)}}function BubbleFloat08(t,a){try{const c=cvCloneImage(a);var h=c.width,o=c.height;for(let t=0;t<400;t++){var e,r,l=Math.floor(Math.random()*h),n=o-Math.floor(Math.random()*+o),i=8+Math.floor(5*Math.random());for(let a=-i;a<=i;a++)for(let t=-i;t<=i;t++)Math.sqrt(t*t+a*a)<=i&&(r=l+t,e=n+a,0<=r&&r<h&&0<=e&&e<o&&(r=4*(e*h+r),c.RGBA[r]=200,c.RGBA[1+r]=200,c.RGBA[2+r]=255))}cvShowImage(t,c)}catch(t){alert("BubbleFloat08 : "+t)}}function MotionBlur(t,n){try{const f=cvCloneImage(n);var i=f.width,c=f.height,a=Math.random()*Math.PI*2,B=Math.cos(a),R=Math.sin(a);for(let l=0;l<c;l++)for(let r=0;r<i;r++){let a=0,h=0,o=0,e=0;for(let t=0;t<12;t++){var G=Math.round(r+B*t),A=Math.round(l+R*t);0<=G&&G<i&&0<=A&&A<c&&(G=4*(A*i+G),a+=n.RGBA[G],h+=n.RGBA[1+G],o+=n.RGBA[2+G],e++)}var M=4*(l*i+r);f.RGBA[M]=a/e,f.RGBA[1+M]=h/e,f.RGBA[2+M]=o/e,f.RGBA[3+M]=n.RGBA[3+M]}cvShowImage(t,f)}catch(t){alert("MotionBlur : "+t)}}function TiltBlur(t,n){try{const A=cvCloneImage(n);var i=A.width,c=A.height,a=c/3;for(let l=0;l<c;l++){var B=Math.min(1,Math.abs(l-c/2)/(a/2));for(let r=0;r<i;r++){let a=0,h=0,o=0,e=0;for(let t=-Math.floor(10*B/2);t<=Math.floor(10*B/2);t++){var R=l+t;0<=R&&R<c&&(R=4*(R*i+r),a+=n.RGBA[R],h+=n.RGBA[1+R],o+=n.RGBA[2+R],e++)}var G=4*(l*i+r);A.RGBA[G]=a/e,A.RGBA[1+G]=h/e,A.RGBA[2+G]=o/e,A.RGBA[3+G]=n.RGBA[3+G]}}cvShowImage(t,A)}catch(t){alert("TiltBlur : "+t)}}function AddFrame05(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<25||r>=h.height-25||o<25||o>=h.width-25)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(10*Math.sin(.3*r+.1*o)),a.RGBA[e]=Math.min(255,139+i),a.RGBA[1+e]=Math.min(255,69+i),a.RGBA[2+e]=Math.min(255,19+i),a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame05 : "+t)}}function AddFrame06(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<25||r>=h.height-25||o<25||o>=h.width-25)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(30*Math.sin(.05*(r+o))),a.RGBA[e]=Math.min(255,180+i),a.RGBA[1+e]=Math.min(255,180+i),a.RGBA[2+e]=Math.min(255,180+i),a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame06 : "+t)}}function AddFrame07(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<25||r>=h.height-25||o<25||o>=h.width-25)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(30*Math.sin(.3*r+.2*o)+30*Math.cos(.1*r)),a.RGBA[e]=Math.min(255,200+i),a.RGBA[1+e]=Math.min(255,200+i),a.RGBA[2+e]=Math.min(255,200+i),a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame07 : "+t)}}function AddFrame08(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<20||r>=h.height-20||o<20||o>=h.width-20)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(20*(Math.sin(.5*r)+Math.cos(.5*o))),a.RGBA[e]=160+i,a.RGBA[1+e]=140+i,a.RGBA[2+e]=120+i,a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame08 : "+t)}}function AddFrame09(t,h){try{for(var a=cvCloneImage(h),r=h.width,e=h.height,i=0;i<e;i++)for(var o,d,A,m,c=0;c<r;c++)(i<30||e-30<=i||c<30||r-30<=c)&&(o=(c+i*r)*CHANNELS,m=Math.min(i,e-i-1,c,r-c-1)/30,d=Math.floor(255*(1-m)),A=Math.floor(128*m),m=Math.floor(255*m),a.RGBA[o]=d,a.RGBA[1+o]=A,a.RGBA[2+o]=m,a.RGBA[3+o]=255);cvShowImage(t,a)}catch(t){alert("AddFrame09 : "+t)}}function AddFrame10(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<25||r>=h.height-25||o<25||o>=h.width-25)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(20*Math.random()),a.RGBA[e]=245-i,a.RGBA[1+e]=240-i,a.RGBA[2+e]=220-i,a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame10 : "+t)}}function AddFrame11(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i=0;i<h.width;i++)(r<10||r>=h.height-10||i<10||i>=h.width-10)&&(e=(i+r*h.width)*CHANNELS,a.RGBA[e]=0,a.RGBA[1+e]=255,a.RGBA[2+e]=255,a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame11 : "+t)}}function AddFrame12(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o=0;o<h.width;o++)(r<20||r>=h.height-20||o<20||o>=h.width-20)&&(e=(o+r*h.width)*CHANNELS,i=Math.floor(30*Math.random()),a.RGBA[e]=212+i,a.RGBA[1+e]=175+i,a.RGBA[2+e]=55+i,a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame12 : "+t)}}function AddFrame13(t,h){try{for(var a=cvCloneImage(h),r=0;r<h.height;r++)for(var e,i,o,d=0;d<h.width;d++)(r<15||r>=h.height-15||d<15||d>=h.width-15)&&(e=(d+r*h.width)*CHANNELS,i=(r+d)%3,o=[[255,105,180],[135,206,250],[144,238,144]],a.RGBA[e]=o[i][0],a.RGBA[1+e]=o[i][1],a.RGBA[2+e]=o[i][2],a.RGBA[3+e]=255);cvShowImage(t,a)}catch(t){alert("AddFrame13 : "+t)}}function AddFrame14(t,h){try{for(var a=cvCloneImage(h),r=h.width/2,e=h.height/2,i=0;i<h.height;i++)for(var o=0;o<h.width;o++){var d=i<30||i>=h.height-30||o<30||o>=h.width-30,A=o-r,m=i-e,m=Math.sqrt(A*A+m*m);(d||m>Math.min(r,e))&&(m=(o+i*h.width)*CHANNELS,a.RGBA[m]=20,a.RGBA[1+m]=20,a.RGBA[2+m]=20,a.RGBA[3+m]=255)}cvShowImage(t,a)}catch(t){alert("AddFrame14 : "+t)}}function HorrorEyesEffect01(t,a){try{const y=cvCloneImage(a);var o=y.width,r=y.height;const C=[];var h=4+Math.floor(6*Math.random());for(let t=0;t<h;t++){var M=Math.floor(Math.random()*o*.8+.1*o),e=Math.floor(Math.random()*r*.8+.1*r),f=20+10*Math.random(),l=.55*f;C.push({cx:M,cy:e,rx:f,ry:l})}for(let t=0;t<C.length;t++){var{cx:n,cy:c,rx:i,ry:A}=C[t],m=n-n,B=c+2*A-c,d=Math.sqrt(m*m+B*B)||1,m=m/d*i*.3,d=B/d*A*.3;for(let a=-Math.ceil(A);a<=Math.ceil(A);a++)for(let t=-Math.ceil(i);t<=Math.ceil(i);t++){var G,R,v,s=n+t,E=c+a;0<=s&&s<o&&0<=E&&E<r&&((R=t*t/(i*i)+a*a/(A*A))<=1&&(v=Math.sqrt(R),G=255-Math.floor(100*v),R=30-Math.floor(20*v),v=30-Math.floor(20*v),E=(s+E*o)*CHANNELS,y.RGBA[E]=G,y.RGBA[1+E]=R,y.RGBA[2+E]=v,y.RGBA[3+E]=255))}var g=.4*A,w=n+m,S=c+d;for(let a=-g;a<=g;a++)for(let t=-g;t<=g;t++){var u=w+t,N=S+a,I=Math.sqrt(t*t+a*a);0<=u&&u<o&&0<=N&&N<r&&I<=g&&(N=(Math.floor(u)+Math.floor(N)*o)*CHANNELS,y.RGBA[N]=0,y.RGBA[1+N]=0,y.RGBA[2+N]=0,y.RGBA[3+N]=255)}}cvShowImage(t,y)}catch(t){alert("HorrorEyesEffect01: "+t)}}function HorrorEyesEffect02(t,a){try{const y=cvCloneImage(a);var o=y.width,r=y.height;const C=[];var h=4+Math.floor(16*Math.random());for(let t=0;t<h;t++){var M=Math.floor(Math.random()*o*.8+.1*o),e=Math.floor(Math.random()*r*.8+.1*r),f=25+15*Math.random(),l=.55*f;C.push({cx:M,cy:e,rx:f,ry:l})}for(let t=0;t<C.length;t++){var{cx:n,cy:c,rx:i,ry:A}=C[t],m=n-n,B=c+2*A-c,d=Math.sqrt(m*m+B*B)||1,m=m/d*i*.3,d=B/d*A*.3;for(let a=-Math.ceil(A);a<=Math.ceil(A);a++)for(let t=-Math.ceil(i);t<=Math.ceil(i);t++){var G,R,v,s=n+t,E=c+a;0<=s&&s<o&&0<=E&&E<r&&((R=t*t/(i*i)+a*a/(A*A))<=1&&(v=Math.sqrt(R),G=255-Math.floor(100*v),R=30-Math.floor(20*v),v=30-Math.floor(20*v),E=(s+E*o)*CHANNELS,y.RGBA[E]=G,y.RGBA[1+E]=R,y.RGBA[2+E]=v,y.RGBA[3+E]=255))}var g=.4*A,w=n+m,S=c+d;for(let a=-g;a<=g;a++)for(let t=-g;t<=g;t++){var u=Math.floor(w+t),N=Math.floor(S+a),I=Math.sqrt(t*t+a*a);0<=u&&u<o&&0<=N&&N<r&&I<=g&&(N=(u+N*o)*CHANNELS,y.RGBA[N]=0,y.RGBA[1+N]=0,y.RGBA[2+N]=0,y.RGBA[3+N]=255)}}cvShowImage(t,y)}catch(t){alert("HorrorEyesEffect02: "+t)}}function HorrorEyesEffect03(t,a){try{const w=cvCloneImage(a);var o=w.width,r=w.height,h=4+Math.floor(3*Math.random());for(let t=0;t<h;t++){var M=Math.floor(Math.random()*o*.8+.1*o),e=Math.floor(Math.random()*r*.8+.1*r),f=40+15*Math.random(),l=.55*f,n=(Math.random()-.5)*f*.4,c=(Math.random()-.5)*l*.4;for(let a=-Math.ceil(l);a<=Math.ceil(l);a++)for(let t=-Math.ceil(f);t<=Math.ceil(f);t++){var i,A,m,B=M+t,d=e+a;0<=B&&B<o&&0<=d&&d<r&&((A=t*t/(f*f)+a*a/(l*l))<=1&&(m=Math.sqrt(A),i=255-Math.floor(100*m),A=30-Math.floor(20*m),m=30-Math.floor(20*m),d=(B+d*o)*CHANNELS,w.RGBA[d]=i,w.RGBA[1+d]=A,w.RGBA[2+d]=m,w.RGBA[3+d]=255))}var G=.4*l,R=M+n,v=e+c;for(let a=-G;a<=G;a++)for(let t=-G;t<=G;t++){var s=Math.floor(R+t),E=Math.floor(v+a),g=Math.sqrt(t*t+a*a);0<=s&&s<o&&0<=E&&E<r&&g<=G&&(E=(s+E*o)*CHANNELS,w.RGBA[E]=0,w.RGBA[1+E]=0,w.RGBA[2+E]=0,w.RGBA[3+E]=255)}}cvShowImage(t,w)}catch(t){alert("HorrorEyesEffect03: "+t)}}let mouseX=0,mouseY=0;function HorrorEyesEffect04(t,a){try{const y=cvCloneImage(a);var o=y.width,r=y.height;const C=[];var h=4+Math.floor(3*Math.random());for(let t=0;t<h;t++){var M=Math.floor(Math.random()*o*.8+.1*o),e=Math.floor(Math.random()*r*.8+.1*r),f=40+20*Math.random(),l=.55*f;C.push({cx:M,cy:e,rx:f,ry:l})}for(let t=0;t<C.length;t++){var{cx:n,cy:c,rx:i,ry:A}=C[t],m=n-n,B=c+2*A-c,d=Math.sqrt(m*m+B*B)||1,m=m/d*i*.3,d=B/d*A*.3;for(let a=-Math.ceil(A);a<=Math.ceil(A);a++)for(let t=-Math.ceil(i);t<=Math.ceil(i);t++){var G,R,v,s=n+t,E=c+a;0<=s&&s<o&&0<=E&&E<r&&((R=t*t/(i*i)+a*a/(A*A))<=1&&(v=Math.sqrt(R),G=255-Math.floor(100*v),R=30-Math.floor(20*v),v=30-Math.floor(20*v),E=(s+E*o)*CHANNELS,y.RGBA[E]=G,y.RGBA[1+E]=R,y.RGBA[2+E]=v,y.RGBA[3+E]=255))}var g=.4*A,w=n+m,S=c+d;for(let a=-g;a<=g;a++)for(let t=-g;t<=g;t++){var u=Math.floor(w+t),N=Math.floor(S+a),I=Math.sqrt(t*t+a*a);0<=u&&u<o&&0<=N&&N<r&&I<=g&&(N=(u+N*o)*CHANNELS,y.RGBA[N]=0,y.RGBA[1+N]=0,y.RGBA[2+N]=0,y.RGBA[3+N]=255)}}cvShowImage(t,y)}catch(t){alert("HorrorEyesEffect04: "+t)}}function SpiderWebEffect01(t,a){try{var o=cvCloneImage(a),r=o.width,h=o.height,M=r/2,e=h/2,f=Math.min(r,h)/2*1.9;for(let t=0;t<22;t++){var l=2*Math.PI/22*t,c=M+f*Math.cos(l),i=e+f*Math.sin(l);!function(a,o,r,h){var M=c-o,e=i-r,f=Math.max(Math.abs(M),Math.abs(e));for(let t=0;t<=f;t++){var l=t/f,n=Math.floor(o+M*l),l=Math.floor(r+e*l);0<=n&&n<a.width&&0<=l&&l<a.height&&(l=(n+l*a.width)*CHANNELS,a.RGBA[l]=h[0],a.RGBA[1+l]=h[1],a.RGBA[2+l]=h[2],a.RGBA[3+l]=h[3])}}(o,M,e,[200,200,255,255])}for(let t=1;t<=16;t++)!function(a,o,r,h,M){var e=1/h;for(let t=0;t<2*Math.PI;t+=e){var f=Math.floor(o+h*Math.cos(t)),l=Math.floor(r+h*Math.sin(t));0<=f&&f<a.width&&0<=l&&l<a.height&&(l=(f+l*a.width)*CHANNELS,a.RGBA[l]=M[0],a.RGBA[1+l]=M[1],a.RGBA[2+l]=M[2],a.RGBA[3+l]=M[3])}}(o,M,e,f*(t/16),[200,200,255,255]);cvShowImage(t,o)}catch(t){alert("SpiderWebEffect01: "+t)}}function SpiderWebEffect02(t,a){try{var o=cvCloneImage(a),r=o.width,h=o.height,M=r/2,e=h/2,f=Math.min(r,h)/2*1.9;const B=new Set;for(let t=0;t<6.6;t++)B.add(Math.floor(22*Math.random()));var l=[180,150,100,255];for(let t=0;t<22;t++){var n,c=2*Math.PI/22*t,i=M+f*Math.cos(c),A=e+f*Math.sin(c);B.has(t)?m(o,M,e,M+f*(n=.4+.4*Math.random())*Math.cos(c),e+f*n*Math.sin(c),l):m(o,M,e,i,A,l)}for(let t=1;t<=16;t++)drawBrokenCircle(o,M,e,f*(t/16),l);cvShowImage(t,o)}catch(t){alert("SpiderWebEffect02: "+t)}function m(a,o,r,t,h,M){var e=t-o,f=h-r,l=Math.max(Math.abs(e),Math.abs(f));for(let t=0;t<=l;t++){var n=t/l;drawThickPixel(a,Math.floor(o+e*n),Math.floor(r+f*n),M)}}}function drawBrokenCircle(a,o,r,h,M){var e=1/h,f=2*Math.random()*Math.PI,l=Math.PI/6+Math.random()*Math.PI/8;for(let t=0;t<2*Math.PI;t+=e)t>f&&t<f+l||drawThickPixel(a,Math.floor(o+h*Math.cos(t)),Math.floor(r+h*Math.sin(t)),M)}function drawThickPixel(a,o,r,h){var M=[[0,0],[-1,0],[1,0],[0,-1],[0,1]];for(let t=0;t<M.length;t++){var[e,f]=M[t],e=o+e,f=r+f;0<=e&&e<a.width&&0<=f&&f<a.height&&(f=(e+f*a.width)*CHANNELS,a.RGBA[f]=h[0],a.RGBA[1+f]=h[1],a.RGBA[2+f]=h[2],a.RGBA[3+f]=h[3])}}function SpiderWebEffect03(t,a){try{var o=cvCloneImage(a),r=o.width,h=o.height,M=.1*r,e=.1*h,f=Math.min(r,h)/2*1.9;const d=new Set;for(let t=0;t<6.6;t++)d.add(Math.floor(22*Math.random()));var l=[180,150,100,255];for(let t=0;t<22;t++){var n,c=2*Math.PI/22*t,i=M+f*Math.cos(c),A=e+f*Math.sin(c);d.has(t)?m(o,M,e,M+f*(n=.4+.4*Math.random())*Math.cos(c),e+f*n*Math.sin(c),l):m(o,M,e,i,A,l)}for(let t=1;t<=16;t++)!function(a,o,r,h,M){var e,f,l=1/h,n=2*Math.random()*Math.PI,c=Math.PI/6+Math.random()*Math.PI/8;for(let t=0;t<2*Math.PI;t+=l)t>n&&t<n+c||(e=Math.floor(o+h*Math.cos(t)),f=Math.floor(r+h*Math.sin(t)),B(a,e,f,M))}(o,M,e,f*(t/16),l);cvShowImage(t,o)}catch(t){alert("SpiderWebEffect03: "+t)}function m(a,o,r,t,h,M){var e=t-o,f=h-r,l=Math.max(Math.abs(e),Math.abs(f));for(let t=0;t<=l;t++){var n=t/l;B(a,Math.floor(o+e*n),Math.floor(r+f*n),M)}}function B(o,r,h,M){[[0,0],[-1,0],[1,0],[0,-1],[0,1]].forEach(function(t){var[a,t]=t,a=r+a,t=h+t;0<=a&&a<o.width&&0<=t&&t<o.height&&(t=(a+t*o.width)*CHANNELS,o.RGBA[t]=M[0],o.RGBA[1+t]=M[1],o.RGBA[2+t]=M[2],o.RGBA[3+t]=M[3])})}}function GhostBlurEffect01(t,a){try{const d=cvCloneImage(a);var r=d.width,h=d.height;for(let t=0;t<3;t++){var M=Math.floor(Math.random()*(r-200))+100,e=Math.floor(Math.random()*(h-300))+100,f=100+60*Math.random(),l=200+80*Math.random();for(let o=0;o<4;o++){var n=6*o;for(let a=0;a<l;a++)for(let t=0;t<f;t++){var c,i,A,m=Math.floor(M+t+n),B=Math.floor(e+a);0<=m&&m<r&&0<=B&&B<h&&(c=(t-f/2)/(f/2),A=(a-l/2)/(l/2),(i=Math.sqrt(c*c+A*A))<1&&(c=(m+B*r)*CHANNELS,A=Math.exp(-Math.pow(2.2*i,2)),m=1-o/4,B=Math.floor(A*m*100),i=Math.floor(230+20*(1-A)),m=Math.floor(230+20*(1-A)),A=Math.floor(255-40*A-10*o),d.RGBA[c]=Math.min(255,d.RGBA[c]+i*(B/255)),d.RGBA[1+c]=Math.min(255,d.RGBA[1+c]+m*(B/255)),d.RGBA[2+c]=Math.min(255,d.RGBA[2+c]+A*(B/255)),d.RGBA[3+c]=Math.min(255,d.RGBA[3+c]+B)))}}}for(let t=0;t<r*h*CHANNELS;t+=CHANNELS)d.RGBA[t]=Math.min(255,.85*d.RGBA[t]),d.RGBA[t+1]=Math.min(255,.9*d.RGBA[t+1]),d.RGBA[t+2]=Math.min(255,1.15*d.RGBA[t+2]);cvShowImage(t,d)}catch(t){alert("GhostBlurEffect01: "+t)}}function GhostBlurEffect02(t,a){try{const d=cvCloneImage(a);var r=d.width,h=d.height;for(let t=0;t<8;t++){var M=Math.floor(Math.random()*(r-200))+100,e=Math.floor(Math.random()*(h-300))+100,f=100+60*Math.random(),l=200+80*Math.random();for(let o=0;o<4;o++){var n=6*o;for(let a=0;a<l;a++)for(let t=0;t<f;t++){var c,i,A,m=Math.floor(M+t+n),B=Math.floor(e+a);0<=m&&m<r&&0<=B&&B<h&&(c=(t-f/2)/(f/2),A=(a-l/2)/(l/2),(i=Math.sqrt(c*c+A*A))<1&&(c=(m+B*r)*CHANNELS,A=Math.exp(-Math.pow(2.2*i,2)),m=1-o/4,B=Math.floor(A*m*100),i=Math.floor(230+20*(1-A)),m=Math.floor(230+20*(1-A)),A=Math.floor(255-40*A-10*o),d.RGBA[c]=Math.min(255,d.RGBA[c]+i*(B/255)),d.RGBA[1+c]=Math.min(255,d.RGBA[1+c]+m*(B/255)),d.RGBA[2+c]=Math.min(255,d.RGBA[2+c]+A*(B/255)),d.RGBA[3+c]=Math.min(255,d.RGBA[3+c]+B)))}}}for(let t=0;t<r*h*CHANNELS;t+=CHANNELS)d.RGBA[t]=Math.min(255,.85*d.RGBA[t]),d.RGBA[t+1]=Math.min(255,.9*d.RGBA[t+1]),d.RGBA[t+2]=Math.min(255,1.15*d.RGBA[t+2]);cvShowImage(t,d)}catch(t){alert("GhostBlurEffect02: "+t)}}function BloodSmudgeEffect(t,a){try{const E=cvCloneImage(a);var o=E.width,r=E.height;for(let t=0;t<4;t++){var h=Math.random()*o,M=Math.random()*r,e=20+20*Math.random(),f=40+60*Math.random();for(let a=-f;a<=f;a++)for(let t=-e;t<=e;t++){var l,n,c,i=Math.floor(h+t),A=Math.floor(M+a);0<=i&&i<o&&0<=A&&A<r&&(c=Math.pow(t/e,2)+Math.pow(a/f,2),l=4*(i+A*o),c<1&&(n=1-c,i=100+Math.floor(50*Math.random()),A=Math.floor(20*Math.random()),c=Math.floor(20*Math.random()),E.RGBA[l]=Math.min(255,E.RGBA[l]*(1-n)+i*n),E.RGBA[1+l]=Math.min(255,E.RGBA[1+l]*(1-n)+A*n),E.RGBA[2+l]=Math.min(255,E.RGBA[2+l]*(1-n)+c*n),E.RGBA[3+l]=255))}var m=30+50*Math.random(),B=4+Math.floor(3*Math.random());for(let t=0;t<m;t++){var d=M+f+t;for(let t=-B;t<=B;t++){var G,R=h+t+2*(Math.random()-.5),v=Math.floor(R),s=Math.floor(d);0<=v&&v<o&&0<=s&&s<r&&(G=4*(v+s*o),R=120+30*Math.random(),v=10*Math.random(),s=10*Math.random(),E.RGBA[G]=R,E.RGBA[1+G]=v,E.RGBA[2+G]=s,E.RGBA[3+G]=255)}}}cvShowImage(t,E)}catch(t){alert("BloodSmudgeEffect: "+t)}}document.addEventListener("mousemove",function(t){var a=document.getElementById("dispImage").getBoundingClientRect();mouseX=t.clientX-a.left,mouseY=t.clientY-a.top});